/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.accessory;

import com.llamalad7.mixinextras.sugar.Local;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.entity.MobRendererPlayer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.client.render.model.ModelPlayer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import teamport.aether.helper.GLManager;
import teamport.aether.items.accessory.IAccessory;
import teamport.aether.items.accessory.ItemGloves;
import teamport.aether.items.accessory.pendant.ItemPendant;
import teamport.aether.items.accessory.trinket.ItemGoldenFeather;
import teamport.aether.items.accessory.trinket.ItemIronBubble;
import teamport.aether.items.accessory.trinket.ItemRegenStone;
import teamport.aether.items.accessory.trinket.ItemShield;

@Environment(value=EnvType.CLIENT)
@Mixin(value={MobRendererPlayer.class}, remap=false)
public abstract class MobRendererPlayerMixinAccessoryRender
extends MobRenderer<Player> {
    @Shadow
    private ModelBiped modelBipedMain;
    @Shadow
    @Final
    private ModelBiped modelArmor;
    @Shadow
    @Final
    private ModelBiped modelArmorChestplate;
    @Unique
    public final ModelBiped modelAccessories = new ModelBiped(1.1f);
    @Unique
    public final ModelBiped modelFeather = new ModelBiped(1.0f);
    @Unique
    public final ModelBiped shield = new ModelBiped(1.5f);
    @Unique
    public boolean shield_6 = false;

    @Shadow
    public abstract void render(Tessellator var1, Player var2, double var3, double var5, double var7, float var9, float var10);

    public MobRendererPlayerMixinAccessoryRender(ModelBase model, float shadowSize) {
        super(model, shadowSize);
    }

    @Inject(method={"drawFirstPersonHand"}, at={@At(value="TAIL")}, cancellable=true)
    public void callDrawFirstPersonHandAfter(@NotNull Player player, boolean isLeft, CallbackInfo ci) {
        ItemStack itemStack = player.inventory.armorInventory[4];
        if (itemStack != null && itemStack.getItem() instanceof ItemGloves) {
            Item item = itemStack.getItem();
            String path = String.format("/assets/%s/textures/armor/gloves/%s_gloves.png", item.namespaceID.namespace(), ((IAccessory)item).name());
            if (this.renderDispatcher.textureManager == null) {
                return;
            }
            this.renderDispatcher.textureManager.loadTexture(path).bind();
            this.modelArmorChestplate.onGround = 0.0f;
            this.modelArmorChestplate.isRiding = false;
            this.modelArmorChestplate.setupAnimation(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            if (this.modelBipedMain instanceof ModelPlayer) {
                if (isLeft) {
                    GL11.glDisable((int)2884);
                    this.modelArmorChestplate.armLeft.visible = true;
                    this.modelArmorChestplate.armLeft.render(0.0625f);
                } else {
                    GL11.glDisable((int)2884);
                    this.modelArmorChestplate.armRight.visible = true;
                    this.modelArmorChestplate.armRight.render(0.0625f);
                }
            }
            this.modelArmorChestplate.armLeft.visible = false;
            this.modelArmorChestplate.armRight.visible = false;
            this.modelArmorChestplate.sneaking = this.modelBipedMain.sneaking;
            this.modelArmorChestplate.holdingRightHand = this.modelBipedMain.holdingRightHand;
            this.modelArmorChestplate.holdingLeftHand = this.modelBipedMain.holdingLeftHand;
            this.modelArmorChestplate.holdingLarge = this.modelBipedMain.holdingLarge;
        }
        ci.cancel();
    }

    @ModifyArg(method={"prepareArmor*"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/player/inventory/container/ContainerInventory;armorItemInSlot(I)Lnet/minecraft/core/item/ItemStack;"))
    public int getArmorItemNotNegative(int i, @Local(argsOnly=true) int renderPass) {
        return renderPass > 3 ? renderPass : 3 - renderPass;
    }

    @Inject(method={"prepareArmor*"}, at={@At(value="TAIL")}, cancellable=true)
    public void setArmorModel(@NotNull Player player, int renderPass, float partialTick, CallbackInfoReturnable<Boolean> info) {
        float swingProgress;
        this.modelAccessories.holdingLarge = this.shield.holdingLarge = this.modelBipedMain.holdingLarge;
        this.modelAccessories.holdingRightHand = this.shield.holdingRightHand = this.modelBipedMain.holdingRightHand;
        this.modelAccessories.holdingLeftHand = this.shield.holdingLeftHand = this.modelBipedMain.holdingLeftHand;
        this.modelAccessories.sneaking = this.shield.sneaking = this.modelBipedMain.sneaking;
        this.modelAccessories.isRiding = this.shield.isRiding = this.modelBipedMain.isRiding;
        this.modelAccessories.onGround = swingProgress = this.getSwingProgress((Mob)player, partialTick);
        this.modelArmor.onGround = swingProgress;
        this.modelArmorChestplate.onGround = swingProgress;
        this.shield.onGround = swingProgress;
        ItemStack armorStack = player.inventory.armorInventory[renderPass];
        if (armorStack != null && armorStack.getItem() instanceof IAccessory && renderPass >= 4) {
            Item item = armorStack.getItem();
            if (item instanceof ItemGloves) {
                String path = String.format("/assets/%s/textures/armor/gloves/%s_gloves.png", item.namespaceID.namespace(), ((IAccessory)item).name());
                this.modelArmorChestplate.holdingRightHand = player.inventory.getCurrentItem() != null;
                this.modelArmorChestplate.sneaking = player.isSneaking();
                this.modelArmorChestplate.isRiding = player.isPassenger();
                this.modelArmorChestplate.armLeft.visible = renderPass == 4;
                this.modelArmorChestplate.armRight.visible = renderPass == 4;
                this.renderDispatcher.textureManager.loadTexture(path).bind();
                this.setArmorModel((ModelBase)this.modelArmorChestplate);
                info.setReturnValue((Object)true);
                return;
            }
            if (item instanceof ItemShield && (renderPass == 7 || player.inventory.armorInventory[7] == null) || this.shield_6) {
                this.shield_6 = false;
                double velocity = MathHelper.sqrt((double)(player.xd * player.xd + player.zd * player.zd));
                String path = player.isSneaking() || player.onGround && velocity < 0.075 ? String.format("/assets/%s/textures/armor/energyGlow.png", item.namespaceID.namespace()) : String.format("/assets/%s/textures/armor/energyNotGlow.png", item.namespaceID.namespace());
                this.renderDispatcher.textureManager.loadTexture(path).bind();
                GLManager.glEnable(2884);
                GLManager.glEnable(3042);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glBlendFunc((int)770, (int)771);
                this.setArmorModel((ModelBase)this.shield);
                info.setReturnValue((Object)true);
                return;
            }
            if (item instanceof ItemShield && renderPass == 6) {
                this.shield_6 = true;
                ItemStack nextSlot = player.inventory.armorInventory[renderPass + 1];
                item = nextSlot.getItem();
            }
            ItemStack slot6 = player.inventory.armorInventory[6];
            if (item instanceof ItemGoldenFeather) {
                int variant = 0;
                if (renderPass == 7 && slot6 != null && slot6.getItem() instanceof ItemGoldenFeather) {
                    variant = 1;
                }
                String path = String.format("/assets/%s/textures/armor/trinkets/%s_trinket_%d.png", item.namespaceID.namespace(), ((IAccessory)item).name(), variant);
                this.renderDispatcher.textureManager.loadTexture(path).bind();
                this.setArmorModel((ModelBase)this.modelFeather);
                this.modelFeather.head.addBox(-4.0f, -12.0f, -4.0f, 8, 12, 12, 1.1f);
                this.modelFeather.body.addBox(-4.0f, -8.0f, 0.0f, 0, 0, 0, 1.0f);
                this.modelFeather.armLeft.addBox(-4.0f, -8.0f, 0.0f, 0, 0, 0, 1.0f);
                this.modelFeather.armRight.addBox(-4.0f, -8.0f, 0.0f, 0, 0, 0, 1.0f);
                this.modelFeather.legLeft.addBox(-4.0f, -8.0f, 0.0f, 0, 0, 0, 1.0f);
                this.modelFeather.legRight.addBox(-4.0f, -8.0f, 0.0f, 0, 0, 0, 1.0f);
                info.setReturnValue((Object)true);
                return;
            }
            if (item instanceof ItemPendant) {
                int variant = 0;
                if (renderPass == 7 && slot6 != null && slot6.getItem() instanceof ItemPendant) {
                    variant = 1;
                }
                String path = String.format("/assets/%s/textures/armor/pendants/%s_pendant_%d.png", item.namespaceID.namespace(), ((IAccessory)item).name(), variant);
                this.modelAccessories.body.visible = true;
                this.renderDispatcher.textureManager.loadTexture(path).bind();
                this.setArmorModel((ModelBase)this.modelAccessories);
                info.setReturnValue((Object)true);
                return;
            }
            if (item instanceof ItemRegenStone) {
                int variant = 0;
                if (renderPass == 7 && slot6 != null && slot6.getItem() instanceof ItemRegenStone) {
                    variant = 1;
                }
                String path = String.format("/assets/%s/textures/armor/trinkets/%s_trinket_%d.png", item.namespaceID.namespace(), ((IAccessory)item).name(), variant);
                this.modelAccessories.body.visible = true;
                this.renderDispatcher.textureManager.loadTexture(path).bind();
                this.setArmorModel((ModelBase)this.modelAccessories);
                info.setReturnValue((Object)true);
                return;
            }
            if (item instanceof ItemIronBubble) {
                int variant = 0;
                if (renderPass == 7 && slot6 != null && slot6.getItem() instanceof ItemIronBubble) {
                    variant = 1;
                }
                String path = String.format("/assets/%s/textures/armor/trinkets/%s_trinket_%d.png", item.namespaceID.namespace(), ((IAccessory)item).name(), variant);
                this.modelAccessories.body.visible = true;
                this.renderDispatcher.textureManager.loadTexture(path).bind();
                this.setArmorModel((ModelBase)this.modelAccessories);
                info.setReturnValue((Object)true);
                return;
            }
        }
        info.setReturnValue((Object)false);
    }
}

