/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.armor.player.phoenix;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLightning;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import teamport.aether.helper.ContainerHelper;
import teamport.aether.helper.ParticleHelper;
import teamport.aether.items.AetherArmorMaterial;
import teamport.aether.mixin.accessors.EntityAccessor;

@Mixin(value={Player.class}, remap=false)
public class PlayerMixinFireImmunity
extends Mob {
    @Shadow
    public ContainerInventory inventory;

    public PlayerMixinFireImmunity(@Nullable World world) {
        super(world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        if (this.isInLava() || this.isInWater()) {
            return;
        }
        if (this.fireResistanceCount() >= 3 && this.random.nextInt(6) == 0) {
            ParticleHelper.spawnFlameParticles(this.world, this.x, this.y, this.z, this.bbHeight, this.bbWidth);
        }
        if (this.fireResistanceCount() >= 5 && this.random.nextInt(3) == 0) {
            ParticleHelper.spawnFlameParticles(this.world, this.x, this.y, this.z, this.bbHeight, this.bbWidth);
        }
    }

    @Inject(method={"lavaHurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void aether$lavaImmunity(CallbackInfo ci) {
        if (this.fireResistanceCount() >= 5) {
            this.aether$damageArmourWithEffect(4);
            ci.cancel();
        }
    }

    @Inject(method={"fireHurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void aether$fireImmunity(CallbackInfo ci) {
        if (this.fireResistanceCount() >= 3) {
            this.aether$damageArmourWithEffect(1);
            ci.cancel();
        }
    }

    public void burn(int damage) {
        if (this.fireResistanceCount() >= 3) {
            this.aether$damageArmourWithEffect(1);
            return;
        }
        super.burn(damage);
    }

    public void thunderHit(EntityLightning bolt) {
        if (this.fireResistanceCount() >= 5) {
            this.hurt(null, 5, DamageType.FIRE);
            this.aether$damageArmourWithEffect(5);
            return;
        }
        super.thunderHit(bolt);
    }

    @Unique
    public int fireResistanceCount() {
        return ContainerHelper.countArmorPiecesOfMaterial(this.inventory, AetherArmorMaterial.PHOENIX);
    }

    @Unique
    public void aether$damageArmourWithEffect(int damage) {
        Player player = (Player)this;
        if ((double)((EntityAccessor)player).getRandom().nextFloat() < (double)0.05f) {
            player.inventory.damageArmor(damage);
            if (this.random.nextInt(6) == 0) {
                this.world.playSoundAtEntity(null, (Entity)this, "random.fizz", 0.5f, 0.8f / (this.random.nextFloat() * 0.2f + 0.9f));
            }
        }
        ParticleHelper.spawnSmokeParticles(this.world, this.x, this.y, this.z, this.bbHeight, this.bbWidth);
    }
}

