/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.dimension;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.sound.SoundCategoryHelper;
import net.minecraft.client.sound.SoundEngine;
import net.minecraft.client.sound.SoundEntry;
import net.minecraft.client.sound.SoundEvent;
import net.minecraft.client.sound.SoundRepository;
import net.minecraft.core.sound.SoundCategory;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import paulscode.sound.SoundSystem;
import teamport.aether.world.AetherDimension;

@Mixin(value={SoundEngine.class}, remap=false)
public abstract class AetherMusicMixin {
    @Shadow
    private Minecraft mc;
    @Shadow
    @Nullable
    private GameSettings options;
    @Shadow
    public int ticksBeforeMusic;
    @Shadow
    @Final
    private Random random;
    @Shadow
    @Nullable
    private static SoundSystem soundSystem;

    @Shadow
    protected abstract boolean isLoaded();

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Ljava/util/concurrent/locks/Lock;lock()V", shift=At.Shift.AFTER)}, cancellable=true)
    public void tick(CallbackInfo ci) {
        if (this.mc.currentWorld.dimension.id != AetherDimension.AetherDimensionID) {
            return;
        }
        ci.cancel();
        if (!this.isLoaded() || SoundCategoryHelper.getEffectiveVolume((SoundCategory)SoundCategory.MUSIC, (GameSettings)this.options) == 0.0f) {
            return;
        }
        if (this.ticksBeforeMusic > 0) {
            --this.ticksBeforeMusic;
            return;
        }
        SoundEvent redirect = SoundRepository.SOUNDS.getRandomSoundFromCategory("aether:music.");
        if (redirect == null) {
            return;
        }
        SoundEntry entry = redirect.getRandomEntry();
        if (entry == null) {
            return;
        }
        this.ticksBeforeMusic = this.random.nextInt(6000) + 6000;
        soundSystem.backgroundMusic("BgMusic", entry.getURL(), entry.name, false);
        soundSystem.setPitch("BgMusic", entry.pitch);
        soundSystem.setVolume("BgMusic", SoundCategoryHelper.getEffectiveVolume((SoundCategory)SoundCategory.MUSIC, (GameSettings)this.options) * entry.volume);
        soundSystem.play("BgMusic");
    }
}

