/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.dimension.bumpToOverworld;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import teamport.aether.entity.AetherMobFallingToOverworld;
import teamport.aether.world.AetherDimension;
import turniplabs.halplibe.helper.EnvironmentHelper;

@Mixin(value={Entity.class}, remap=false)
public abstract class EntityBumpToOverworldMixin {
    @Shadow
    @Nullable
    public World world;
    @Shadow
    public double y;
    @Shadow
    @Nullable
    public Entity passenger;
    private final Entity thisAs = (Entity)Entity.class.cast(this);

    @Shadow
    public abstract void remove();

    @Shadow
    public abstract Entity ejectRider();

    @Shadow
    public abstract boolean isPassenger();

    @Shadow
    @Nullable
    public abstract Entity getPassenger();

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void fallToOverWorld(CallbackInfo ci) {
        if (EnvironmentHelper.isClientWorld()) {
            return;
        }
        Dimension dimension = this.world.dimension;
        if (dimension.id == AetherDimension.AetherDimensionID && this.y < (double)(this.world.worldType.getMinY() - 10)) {
            if (this.getPassenger() != null) {
                if (this.getPassenger() instanceof Player) {
                    return;
                }
                this.ejectRider();
            }
            if (this.thisAs instanceof AetherMobFallingToOverworld) {
                ((AetherMobFallingToOverworld)this.thisAs).onLeavingAether();
                if (!((AetherMobFallingToOverworld)this.thisAs).canFallToOverworld()) {
                    this.remove();
                    return;
                }
            }
            AetherDimension.addEntityToFallen((Entity)Entity.class.cast(this));
        }
    }
}

