/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.item;

import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import teamport.aether.helper.ParticleHelper;
import teamport.aether.world.AetherDimension;

@Mixin(value={ItemBlock.class}, remap=false)
public abstract class ItemBlockBlacklistMixin {
    @Shadow
    @NotNull
    protected Block<?> block;

    @Shadow
    public abstract int getPlacedBlockMetadata(@Nullable Player var1, ItemStack var2, World var3, int var4, int var5, int var6, Side var7, double var8, double var10);

    @Inject(method={"onUseItemOnBlock"}, at={@At(value="HEAD")}, cancellable=true)
    public void banBlocksFromDimensions(ItemStack stack, Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced, CallbackInfoReturnable<Boolean> cir) {
        Dimension dim = world.dimension;
        List<Integer> BLACKLIST = AetherDimension.getDimensionBlacklist(dim);
        if (BLACKLIST.contains(this.block.id())) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();
            if (dim == AetherDimension.AETHER) {
                int meta;
                if (this.block.id() == Blocks.PUMPKIN_CARVED_ACTIVE.id() && world.canBlockBePlacedAt(this.block.id(), blockX, blockY, blockZ, false, side) && stack.consumeItem(player)) {
                    meta = this.getPlacedBlockMetadata(player, stack, world, blockX, blockY, blockZ, side, xPlaced, yPlaced);
                    if (world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Blocks.PUMPKIN_CARVED_IDLE.id(), meta)) {
                        if (player != null) {
                            this.block.onBlockPlacedByMob(world, blockX, blockY, blockZ, side, (Mob)player, xPlaced, yPlaced);
                        } else {
                            this.block.onBlockPlacedByWorld(world, blockX, blockY, blockZ);
                        }
                        world.playBlockSoundEffect((Entity)player, (double)((float)blockX + 0.5f), (double)((float)blockY + 0.5f), (double)((float)blockZ + 0.5f), this.block, EnumBlockSoundEffectType.PLACE);
                    }
                    if (player != null && player.getGamemode().consumeBlocks()) {
                        ++stack.stackSize;
                    }
                }
                if (this.block.id() == Blocks.BRAZIER_ACTIVE.id() && world.canBlockBePlacedAt(this.block.id(), blockX, blockY, blockZ, false, side) && stack.consumeItem(player)) {
                    meta = this.getPlacedBlockMetadata(player, stack, world, blockX, blockY, blockZ, side, xPlaced, yPlaced);
                    if (world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Blocks.BRAZIER_INACTIVE.id(), meta)) {
                        if (player != null) {
                            this.block.onBlockPlacedByMob(world, blockX, blockY, blockZ, side, (Mob)player, xPlaced, yPlaced);
                        } else {
                            this.block.onBlockPlacedByWorld(world, blockX, blockY, blockZ);
                        }
                        world.playBlockSoundEffect((Entity)player, (double)((float)blockX + 0.5f), (double)((float)blockY + 0.5f), (double)((float)blockZ + 0.5f), this.block, EnumBlockSoundEffectType.PLACE);
                    }
                    if (player != null && player.getGamemode().consumeBlocks()) {
                        ++stack.stackSize;
                    }
                }
                for (int l = 0; l < 8; ++l) {
                    double angle = Math.toRadians(l * 45);
                    ParticleHelper.spawnParticle(world, "smoke", (double)blockX + 0.5, (double)blockY + 0.2, (double)blockZ + 0.5, -Math.cos(angle) / 20.0, 0.03, -Math.sin(angle) / 20.0, 0);
                    ParticleHelper.spawnParticle(world, "largesmoke", (double)blockX + Math.random(), (double)blockY + 0.2, (double)blockZ + Math.random(), 0.0, 0.0, 0.0, 0);
                }
                world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)blockX + 0.5, (double)blockY + 0.5, (double)blockZ + 0.5, "fire.ignite", 1.0f, world.rand.nextFloat() * 0.4f + 0.8f);
                world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)((float)blockX + 0.5f), (double)((float)blockY + 0.5f), (double)((float)blockZ + 0.5f), "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
            }
            cir.setReturnValue((Object)true);
        }
    }
}

