/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.models.dungeon;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import teamport.aether.blocks.dungeon.BlockLogicChestMimic;

@Environment(value=EnvType.CLIENT)
public class BlockModelMimic<T extends BlockLogicChestMimic>
extends BlockModelStandard<T> {
    protected IconCoordinate frontTexture;
    protected IconCoordinate sideTexture;
    protected IconCoordinate topTexture;

    public BlockModelMimic(Block<T> block, String rootKey) {
        super(block);
        this.frontTexture = TextureRegistry.getTexture((String)(rootKey + "front"));
        this.sideTexture = TextureRegistry.getTexture((String)(rootKey + "side"));
        this.topTexture = TextureRegistry.getTexture((String)(rootKey + "top"));
    }

    public boolean render(Tessellator tessellator, int x, int y, int z) {
        int meta = BlockModelMimic.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        Direction dir = BlockLogicChest.getDirectionFromMeta((int)meta);
        switch (dir) {
            case NORTH: {
                BlockModelMimic.renderBlocks.uvRotateTop = 3;
                BlockModelMimic.renderBlocks.uvRotateBottom = 3;
                break;
            }
            case EAST: {
                BlockModelMimic.renderBlocks.uvRotateTop = 2;
                BlockModelMimic.renderBlocks.uvRotateBottom = 1;
                break;
            }
            case WEST: {
                BlockModelMimic.renderBlocks.uvRotateTop = 1;
                BlockModelMimic.renderBlocks.uvRotateBottom = 2;
            }
        }
        this.renderStandardBlock(tessellator, this.block.getBlockBoundsFromState(BlockModelMimic.renderBlocks.blockAccess, x, y, z), x, y, z);
        this.resetRenderBlocks();
        return true;
    }

    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int meta = blockAccess.getBlockMetadata(x, y, z);
        Side facing = BlockLogicChest.getDirectionFromMeta((int)meta).getSide();
        if (side == Side.TOP || side == Side.BOTTOM) {
            return this.topTexture;
        }
        if (side == facing) {
            return this.frontTexture;
        }
        return side.isHorizontal() ? this.sideTexture : this.topTexture;
    }

    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (side == Side.SOUTH) {
            return this.frontTexture;
        }
        return side.isHorizontal() ? this.sideTexture : this.topTexture;
    }
}

