/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.net.message;

import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.PlayerServer;
import net.minecraft.server.net.PlayerList;
import org.jetbrains.annotations.NotNull;
import teamport.aether.models.DynamicTextureDungeonCompass;
import teamport.aether.world.AetherDimension;
import teamport.aether.world.generate.feature.components.WorldFeaturePoint;
import teamport.aether.world.generate.feature.dungeon.map.DungeonMap;
import teamport.aether.world.generate.feature.dungeon.map.DungeonMapEntry;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class AetherDungeonMapUpdateNetworkMessage
implements NetworkMessage {
    private UUID playerUUID;
    private final List<DungeonMapEntry> entriesReceived = new ArrayList<DungeonMapEntry>();

    public AetherDungeonMapUpdateNetworkMessage() {
    }

    public AetherDungeonMapUpdateNetworkMessage(UUID uuid) {
        this.playerUUID = uuid;
    }

    public void encodeToUniversalPacket(@NotNull UniversalPacket packet) {
        if (EnvironmentHelper.isServerEnvironment()) {
            PlayerList playerList = MinecraftServer.getInstance().playerList;
            Optional<PlayerServer> player = playerList.playerEntities.stream().filter(p -> p.uuid.compareTo(this.playerUUID) == 0).findFirst();
            if (!player.isPresent()) {
                packet.writeInt(0);
                return;
            }
            List entries = AetherDimension.dungeonMap.values().stream().filter(Objects::nonNull).filter(d -> d.getPosition() != null).filter(d -> d.getPosition().distanceTo(WorldFeaturePoint.wfpoint((Entity)player.get())) < 300.0).collect(Collectors.toList());
            packet.writeInt(entries.toArray().length);
            for (DungeonMapEntry entry : entries) {
                CompoundTag tag = new CompoundTag();
                entry.writeToNBT(tag);
                packet.writeInt(entry.getId());
                packet.writeCompoundTag(tag);
            }
        } else {
            packet.writeString(Minecraft.getMinecraft().thePlayer.uuid.toString());
        }
    }

    public void decodeFromUniversalPacket(@NotNull UniversalPacket packet) {
        if (EnvironmentHelper.isServerEnvironment()) {
            this.playerUUID = UUID.fromString(packet.readString());
        } else {
            this.entriesReceived.clear();
            int entriesLength = packet.readInt();
            for (int i = 0; i < entriesLength; ++i) {
                int id = packet.readInt();
                CompoundTag tag = packet.readCompoundTag();
                DungeonMapEntry entry = DungeonMap.readDungeonMapEntryFromNBT(tag, id);
                this.entriesReceived.add(entry);
            }
        }
    }

    public void handle(NetworkMessage.NetworkContext context) {
        if (EnvironmentHelper.isServerEnvironment()) {
            if (context.player == null) {
                return;
            }
            NetworkHandler.sendToPlayer((Player)context.player, (NetworkMessage)new AetherDungeonMapUpdateNetworkMessage(context.player.uuid));
            return;
        }
        if (EnvironmentHelper.isClientWorld()) {
            List<DungeonMapEntry> cache = DynamicTextureDungeonCompass.entryListCache;
            cache.clear();
            cache.addAll(this.entriesReceived);
            return;
        }
    }
}

