/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.recipe;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.HasJsonAdapter;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeGroup;
import net.minecraft.core.data.registry.recipe.RecipeNamespace;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.adapter.RecipeJsonAdapter;
import net.minecraft.core.item.ItemStack;
import teamport.aether.recipe.RecipeAetherMachineJsonAdapter;

public class RecipeEntryAetherMachine
extends RecipeEntryBase<RecipeSymbol, ItemStack, Integer>
implements HasJsonAdapter {
    public RecipeEntryAetherMachine(RecipeSymbol input, ItemStack output, Integer time) {
        super((Object)input, (Object)output, (Object)time);
    }

    public RecipeEntryAetherMachine() {
    }

    public boolean matchesQueryIgnoreExceptions(SearchQuery query) {
        try {
            return this.matchesQuery(query);
        }
        catch (IllegalArgumentException | NullPointerException var3) {
            return false;
        }
    }

    public boolean matches(ItemStack stack) {
        return ((RecipeSymbol)this.getInput()).matches(stack);
    }

    public boolean matchesQuery(SearchQuery query) {
        switch (query.mode) {
            case ALL: {
                if (!this.matchesRecipe(query) && !this.matchesUsage(query) || !this.matchesScope(query)) break;
                return true;
            }
            case RECIPE: {
                if (!this.matchesRecipe(query) || !this.matchesScope(query)) break;
                return true;
            }
            case USAGE: {
                if (!this.matchesUsage(query) || !this.matchesScope(query)) break;
                return true;
            }
        }
        return false;
    }

    public boolean matchesScope(SearchQuery query) {
        if (query.scope.getLeft() == SearchQuery.SearchScope.NONE) {
            return true;
        }
        if (query.scope.getLeft() == SearchQuery.SearchScope.NAMESPACE) {
            RecipeNamespace namespace = (RecipeNamespace)Registries.RECIPES.getItem((String)query.scope.getRight());
            return namespace == this.parent.getParent();
        }
        if (query.scope.getLeft() == SearchQuery.SearchScope.NAMESPACE_GROUP) {
            RecipeGroup group;
            try {
                group = Registries.RECIPES.getGroupFromKey((String)query.scope.getRight());
            }
            catch (IllegalArgumentException e) {
                group = null;
            }
            return group == this.parent;
        }
        return false;
    }

    public boolean matchesRecipe(SearchQuery query) {
        if (query.query.getLeft() == SearchQuery.QueryType.NAME) {
            if (query.strict && ((ItemStack)this.getOutput()).getDisplayName().equalsIgnoreCase((String)query.query.getRight())) {
                return true;
            }
            return !query.strict && ((ItemStack)this.getOutput()).getDisplayName().toLowerCase().contains(((String)query.query.getRight()).toLowerCase());
        }
        if (query.query.getLeft() == SearchQuery.QueryType.GROUP && !Objects.equals(query.query.getRight(), "")) {
            List groupStacks = new RecipeSymbol((String)query.query.getRight()).resolve();
            if (groupStacks == null) {
                return false;
            }
            return groupStacks.contains(this.getOutput());
        }
        return false;
    }

    public boolean matchesUsage(SearchQuery query) {
        List stacks = ((RecipeSymbol)this.getInput()).resolve();
        for (ItemStack stack : stacks) {
            if (stack == null) continue;
            if (query.query.getLeft() == SearchQuery.QueryType.NAME) {
                if (query.strict && stack.getDisplayName().equalsIgnoreCase((String)query.query.getRight())) {
                    return true;
                }
                if (query.strict || !stack.getDisplayName().toLowerCase().contains(((String)query.query.getRight()).toLowerCase())) continue;
                return true;
            }
            if (query.query.getLeft() != SearchQuery.QueryType.GROUP || Objects.equals(query.query.getRight(), "")) continue;
            List groupStacks = new RecipeSymbol((String)query.query.getRight()).resolve();
            if (groupStacks == null) {
                return false;
            }
            return groupStacks.contains(this.getOutput());
        }
        return false;
    }

    public RecipeJsonAdapter<?> getAdapter() {
        return new RecipeAetherMachineJsonAdapter();
    }
}

