/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.generate.feature.components.dungeon.bronze;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.block.BlockLogicMobSpawner;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import org.jetbrains.annotations.Nullable;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.blocks.dungeon.BlockLogicChestLocked;
import teamport.aether.blocks.dungeon.BlockLogicDungeonDoor;
import teamport.aether.blocks.dungeon.BlockLogicLocked;
import teamport.aether.blocks.dungeon.BlockLogicPaintedChestMimic;
import teamport.aether.entity.tile.TileEntityMimic;
import teamport.aether.world.generate.feature.BlockPallet;
import teamport.aether.world.generate.feature.components.WorldFeatureBlock;
import teamport.aether.world.generate.feature.components.WorldFeatureComponent;
import teamport.aether.world.generate.feature.components.WorldFeaturePoint;
import teamport.aether.world.generate.feature.dungeon.WorldFeatureAetherBronzeDungeon;

public abstract class BaseBronzeRoom
extends WorldFeature {
    public World world;
    public Random random;
    public int x;
    public int y;
    public int z;
    public int height = 12;
    public int width = 12;
    public int length = 12;
    public float airTolerance = 0.45f;
    public float topAirTolerance = 0.2f;
    public float bottomAirTolerance = 0.2f;
    public float liquidTolerance = 0.45f;
    public float topLiquidTolerance = 0.2f;
    public float bottomLiquidTolerance = 0.2f;
    public float roomWeight = 1.0f;
    protected WorldFeatureComponent room = new WorldFeatureComponent();
    protected WorldFeatureComponent decoration;
    protected WorldFeatureComponent chest = new WorldFeatureComponent();
    protected List<Door> doors;
    private boolean doorCoordinatesAdjusted = false;
    public static BlockPallet ROOM_PALLET = new BlockPallet();
    public static BlockPallet chestOrMimic;

    public BaseBronzeRoom() {
        this.decoration = new WorldFeatureComponent();
        this.doors = new ArrayList<Door>();
    }

    public BaseBronzeRoom setCoords(WorldFeaturePoint p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
        return this;
    }

    public BaseBronzeRoom setCoords(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public BaseBronzeRoom set(World world, Random random, int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.random = random;
        this.world = world;
        return this;
    }

    public WorldFeatureComponent getRoom() {
        return this.room;
    }

    public WorldFeatureComponent getDecoration() {
        return this.decoration;
    }

    public WorldFeatureComponent getChest() {
        return this.chest;
    }

    public List<Door> getAdjustedDoors() {
        if (this.doorCoordinatesAdjusted) {
            return this.doors;
        }
        return new ArrayList<Door>();
    }

    public List<Door> getDoors() {
        if (this.doorCoordinatesAdjusted) {
            WorldFeaturePoint point = WorldFeaturePoint.wfp(this.x, this.y, this.z);
            ArrayList<Door> doorList = new ArrayList<Door>();
            for (Door d : this.doors) {
                Door copy = d.copy();
                copy.p1.subtract(point);
                copy.p2.subtract(point);
                doorList.add(copy);
            }
            return doorList;
        }
        return this.doors;
    }

    public void addDoor(Direction heading, WorldFeaturePoint p1, Direction direction1, int length1, Direction direction2, int length2) {
        WorldFeaturePoint p2 = new WorldFeaturePoint(p1.x, p1.y, p1.z);
        p2.add(direction1.getOffsetX() * length1, direction1.getOffsetY() * length1, direction1.getOffsetZ() * length1);
        p2.add(direction2.getOffsetX() * length2, direction2.getOffsetY() * length2, direction2.getOffsetZ() * length2);
        this.addDoor(heading, p1, p2);
    }

    public void addDoor(Direction direction, WorldFeaturePoint p1, WorldFeaturePoint p2) {
        this.doors.add(new Door(direction, p1, p2));
    }

    public final boolean place(World world, Random random, int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.random = random;
        this.world = world;
        if (!this.canPlace()) {
            return false;
        }
        this.adjustDoorCoordinates();
        this.makeRoom();
        this.placeRoom();
        return true;
    }

    public boolean canPlace() {
        Material blockMaterial;
        Block block;
        if (this.y <= 11 && this.y + this.height + 3 >= this.world.getHeightBlocks()) {
            return false;
        }
        int countAir = 0;
        int countLiquid = 0;
        WorldFeatureComponent check = WorldFeatureComponent.drawPlane(0, 0, Direction.SOUTH, this.width, Direction.EAST, this.length, this.x, this.y + this.height, this.z, true);
        for (WorldFeaturePoint worldFeaturePoint : check.blockList) {
            block = this.world.getBlock(worldFeaturePoint.x, worldFeaturePoint.y, worldFeaturePoint.z);
            Material material = blockMaterial = block == null ? Material.air : block.getMaterial();
            if (block != null && block.blockHardness < 0.0f) {
                return false;
            }
            if (blockMaterial == Material.air) {
                ++countAir;
            }
            if (!blockMaterial.isLiquid()) continue;
            ++countLiquid;
        }
        if ((float)check.blockList.size() * this.topAirTolerance < (float)countAir || (float)check.blockList.size() * this.topLiquidTolerance < (float)countLiquid) {
            return false;
        }
        check = WorldFeatureComponent.drawPlane(0, 0, Direction.SOUTH, this.width, Direction.EAST, this.length, this.x, this.y, this.z, true);
        countLiquid = 0;
        countAir = 0;
        for (WorldFeaturePoint worldFeaturePoint : check.blockList) {
            block = this.world.getBlock(worldFeaturePoint.x, worldFeaturePoint.y, worldFeaturePoint.z);
            Material material = blockMaterial = block == null ? Material.air : block.getMaterial();
            if (block != null && block.blockHardness < 0.0f) {
                return false;
            }
            if (blockMaterial == Material.air) {
                ++countAir;
            }
            if (!blockMaterial.isLiquid()) continue;
            ++countLiquid;
        }
        if ((float)check.blockList.size() * this.bottomAirTolerance < (float)countAir || (float)check.blockList.size() * this.bottomLiquidTolerance < (float)countLiquid) {
            return false;
        }
        check = WorldFeatureComponent.drawVolume(0, 0, Direction.SOUTH, this.width, Direction.UP, this.height, Direction.EAST, this.length, this.x, this.y, this.z, true);
        countLiquid = 0;
        countAir = 0;
        for (WorldFeaturePoint worldFeaturePoint : check.blockList) {
            block = this.world.getBlock(worldFeaturePoint.x, worldFeaturePoint.y, worldFeaturePoint.z);
            Material material = blockMaterial = block == null ? Material.air : block.getMaterial();
            if (block != null && block.blockHardness < 0.0f) {
                return false;
            }
            if (blockMaterial == Material.air) {
                ++countAir;
            }
            if (!blockMaterial.isLiquid()) continue;
            ++countLiquid;
        }
        return !((float)check.blockList.size() * this.airTolerance < (float)countAir) && !((float)check.blockList.size() * this.liquidTolerance < (float)countLiquid);
    }

    public void adjustDoorCoordinates() {
        for (Door door : this.doors) {
            door.p1.add(this.x, this.y, this.z);
            door.p2.add(this.x, this.y, this.z);
        }
        this.doorCoordinatesAdjusted = true;
    }

    public abstract void makeRoom();

    public void placeRoom() {
        HashMap<WorldFeaturePoint, WorldFeatureBlock> blockMap = new HashMap<WorldFeaturePoint, WorldFeatureBlock>();
        for (WorldFeatureBlock block : this.room.blockList) {
            WorldFeaturePoint point = new WorldFeaturePoint(block.x, block.y, block.z);
            blockMap.put(point, block);
        }
        this.decoration.add(this.chest);
        for (WorldFeatureBlock block : this.decoration.blockList) {
            WorldFeatureBlock otherBlock = blockMap.computeIfAbsent(WorldFeaturePoint.wfp(block.x, block.y, block.z), key -> block);
            otherBlock.blockID = block.blockID;
            otherBlock.metadata = block.metadata;
            otherBlock.withNotify = block.withNotify;
        }
        for (WorldFeatureBlock wfblock : blockMap.values()) {
            if (!BaseBronzeRoom.roomCanReplace(this.world, wfblock)) continue;
            wfblock.place(this.world);
        }
        for (WorldFeatureBlock wfblock : this.chest.blockList) {
            BlockLogicChest.setDefaultDirection((World)this.world, (int)wfblock.x, (int)wfblock.y, (int)wfblock.z);
            WorldFeatureComponent.populateChest(this.world, this.random, wfblock, WorldFeatureAetherBronzeDungeon::generateLoot);
            if (this.world.rand.nextInt(250) != 0 || wfblock.blockID != AetherBlocks.CHEST_MIMIC_SKYROOT.id()) continue;
            BlockLogicPaintedChestMimic blockLogic = (BlockLogicPaintedChestMimic)AetherBlocks.CHEST_MIMIC_SKYROOT_PAINTED.getLogic();
            this.world.setBlockRaw(wfblock.x, wfblock.y, wfblock.z, AetherBlocks.CHEST_MIMIC_SKYROOT_PAINTED.id());
            blockLogic.setColor(this.world, wfblock.x, wfblock.y, wfblock.z, DyeColor.PURPLE);
            ((TileEntityMimic)this.world.getTileEntity(wfblock.x, wfblock.y, wfblock.z)).setCustomName("Wallace", (byte)TextFormatting.PURPLE.id);
        }
    }

    public static boolean roomCanReplace(World world, WorldFeatureBlock wfblock) {
        Material blockMaterial;
        Block block = world.getBlock(wfblock.x, wfblock.y, wfblock.z);
        int blockID = block == null ? 0 : block.id();
        Material material = blockMaterial = blockID == 0 ? Material.air : block.getMaterial();
        if (block != null) {
            BlockLogic logic = block.getLogic();
            if (logic instanceof BlockLogicLocked || logic instanceof BlockLogicMobSpawner || logic instanceof BlockLogicChestLocked || logic instanceof BlockLogicDungeonDoor) {
                return false;
            }
            if (block.blockHardness < 0.0f) {
                return false;
            }
        }
        if (blockMaterial == Material.water || blockMaterial == Material.lava) {
            return false;
        }
        if (blockID == Blocks.SPIKES.id()) {
            return true;
        }
        if (blockID == AetherBlocks.CHEST_MIMIC_OAK.id() || blockID == AetherBlocks.CHEST_PLANKS_SKYROOT.id()) {
            world.removeBlockTileEntity(wfblock.x, wfblock.y, wfblock.z);
            return true;
        }
        return BlockTags.CAVES_CUT_THROUGH.appliesTo((ITaggable)block) || blockMaterial == Material.grass || blockMaterial == Material.dirt || blockMaterial == Material.marble || blockMaterial == Material.moss || blockMaterial.isStone();
    }

    public List<Door> getAvailableDoors() {
        ArrayList<Door> freeDoors = new ArrayList<Door>();
        for (Door door : this.doors) {
            if (door.mark != ClosingType.OPEN) continue;
            freeDoors.add(door);
        }
        return freeDoors;
    }

    public void markDoor(@Nullable Door door, ClosingType closingType) {
        if (door == null) {
            return;
        }
        door.mark = closingType;
    }

    public List<WorldFeaturePoint> getAchors(WorldFeaturePoint doorPoint, Direction heading) {
        ArrayList<WorldFeaturePoint> list = new ArrayList<WorldFeaturePoint>();
        for (Door door : this.doors) {
            if (door.heading != heading.getOpposite()) continue;
            list.add(new WorldFeaturePoint(doorPoint.x - door.p1.x, doorPoint.y - door.p1.y, doorPoint.z - door.p1.z));
        }
        return list;
    }

    public Door getDoor(WorldFeaturePoint nextDoor) {
        for (Door door : this.doors) {
            if (!door.p1.equals(nextDoor) && !door.p2.equals(nextDoor)) continue;
            return door;
        }
        return null;
    }

    public boolean intercept(WorldFeaturePoint point) {
        return point.x <= this.x + this.length && point.x >= this.x && point.y <= this.y + this.height && point.y >= this.y && point.z <= this.z + this.width && point.z >= this.z;
    }

    public boolean intercept(WorldFeaturePoint point, BaseBronzeRoom room) {
        return point.x <= this.x + this.length && point.x + room.length >= this.x && point.y <= this.y + this.height && point.y + room.height >= this.y && point.z <= this.z + this.width && point.z + room.width >= this.z;
    }

    static {
        ROOM_PALLET.addEntry(AetherBlocks.CARVED_STONE.id(), 0, 85.0);
        ROOM_PALLET.addEntry(AetherBlocks.CARVED_STONE_LIGHT.id(), 0, 5.0);
        ROOM_PALLET.addEntry(AetherBlocks.CARVED_STONE_TRAPPED.id(), 0, 10.0);
        chestOrMimic = new BlockPallet();
        chestOrMimic.addEntry(0, 1.5);
        chestOrMimic.addEntry(AetherBlocks.CHEST_PLANKS_SKYROOT.id(), 1.0);
        chestOrMimic.addEntry(AetherBlocks.CHEST_MIMIC_SKYROOT.id(), 1.0);
    }

    public static class Door {
        public Direction heading;
        public WorldFeaturePoint p1;
        public WorldFeaturePoint p2;
        public ClosingType mark;

        Door(Direction heading, WorldFeaturePoint p1, WorldFeaturePoint p2) {
            this.heading = heading;
            this.p1 = p1;
            this.p2 = p2;
            this.mark = ClosingType.OPEN;
        }

        public static Door door(Direction heading, WorldFeaturePoint p1, WorldFeaturePoint p2) {
            return new Door(heading, p1, p2);
        }

        public String toString() {
            return String.format("(%s, %s, %s, %s)", new Object[]{this.heading, this.p1, this.p2, this.mark});
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.heading, this.p1.hashCode(), this.p2.hashCode(), this.mark});
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Door)) {
                return false;
            }
            Door d = (Door)o;
            return this.heading.equals((Object)d.heading) && this.p1.equals(d.p1) && this.p2.equals(d.p2);
        }

        public Door copy() {
            return new Door(this.heading, this.p1.copy(), this.p2.copy());
        }
    }

    public static enum ClosingType {
        INTERCEPT,
        NO_SPACE,
        ROOM_LOCKED,
        OPEN,
        PLACED;

    }
}

