/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.generate.feature.dungeon.map;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.world.World;
import teamport.aether.AetherMod;
import teamport.aether.world.generate.feature.dungeon.map.DungeonMapEntry;
import teamport.aether.world.generate.feature.dungeon.map.DungeonMapEntrySlider;

public class DungeonMap {
    private static final HashMap<String, Class<? extends DungeonMapEntry>> KEY_TYPE_MAP = new HashMap();
    private static final HashMap<Class<? extends DungeonMapEntry>, String> TYPE_KEY_MAP = new HashMap();
    protected static HashMap<Integer, DungeonMapEntry> dungeonMap;

    public static void registerDungeonType(String key, Class<? extends DungeonMapEntry> type) {
        KEY_TYPE_MAP.put(key, type);
        TYPE_KEY_MAP.put(type, key);
    }

    public DungeonMapEntry getDungeon(int id) {
        return dungeonMap.get(id);
    }

    public Collection<DungeonMapEntry> values() {
        return dungeonMap.values();
    }

    public boolean isEmpty() {
        return dungeonMap.isEmpty();
    }

    public <T extends Entity> void notifyBossDead(Integer id, T boss) {
        if (dungeonMap.get(id) == null) {
            AetherMod.LOGGER.error("Couldn't find dungeon of id {}", (Object)id);
            return;
        }
        dungeonMap.get(id).notifyBossDead(boss);
    }

    public void remove(Integer id, World world) {
        if (dungeonMap.get(id) == null) {
            AetherMod.LOGGER.error("Couldn't find dungeon of id {}", (Object)id);
            return;
        }
        dungeonMap.get(id).remove(world);
    }

    public <T extends DungeonMapEntry> T register(Class<T> dungeon) {
        DungeonMapEntry result;
        int id = dungeonMap.size();
        while (dungeonMap.get(id) != null) {
            ++id;
        }
        try {
            result = (DungeonMapEntry)dungeon.getConstructor(Integer.class).newInstance(id);
        }
        catch (Exception e) {
            AetherMod.LOGGER.error("Failed to register dungeon!");
            throw new RuntimeException(e);
        }
        dungeonMap.put(id, result);
        return (T)result;
    }

    public static DungeonMapEntry readDungeonMapEntryFromNBT(CompoundTag tag, int id) {
        DungeonMapEntry dungeonEntry;
        String type = tag.getString("type");
        try {
            dungeonEntry = KEY_TYPE_MAP.get(type).getConstructor(Integer.class).newInstance(id);
        }
        catch (Exception e) {
            AetherMod.LOGGER.error("Failed to load dungeon {} from map!", (Object)id);
            AetherMod.LOGGER.error("Defaulting to base dungeon entry...");
            dungeonEntry = new DungeonMapEntry(id);
        }
        dungeonEntry.loadFromNBT(tag);
        return dungeonEntry;
    }

    public void loadFromNBT(CompoundTag data) {
        dungeonMap.clear();
        for (Tag tag : data.getValues()) {
            if (!(tag instanceof CompoundTag)) continue;
            int id = Integer.parseInt(tag.getTagName());
            DungeonMapEntry dungeonEntry = DungeonMap.readDungeonMapEntryFromNBT((CompoundTag)tag, id);
            dungeonMap.put(dungeonEntry.id, dungeonEntry);
        }
    }

    public CompoundTag writeToNBT(CompoundTag data) {
        dungeonMap.forEach((id, dungeon) -> {
            CompoundTag dungeonData = dungeon.writeToNBT(new CompoundTag());
            dungeonData.putString("type", TYPE_KEY_MAP.get(dungeon.getClass()));
            data.put(String.valueOf(id), (Tag)dungeonData);
        });
        return data;
    }

    static {
        DungeonMap.registerDungeonType("SLIDER", DungeonMapEntrySlider.class);
        DungeonMap.registerDungeonType("BASE", DungeonMapEntry.class);
        dungeonMap = new HashMap();
    }
}

