/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.type;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.worldtype.WorldTypeFX;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.type.WorldType;

@Environment(value=EnvType.CLIENT)
public class WorldTypeFXAether
extends WorldTypeFX {
    public Float cloudHeight = null;

    public WorldTypeFXAether(WorldType worldType) {
        super(worldType);
    }

    public boolean hasGround() {
        return false;
    }

    public WorldTypeFX setCloudHeight(float cloudHeight) {
        this.cloudHeight = Float.valueOf(cloudHeight);
        return this;
    }

    public float getCloudHeight() {
        return this.cloudHeight == null ? (float)(this.worldType.getMaxY() / 2 + 1 - 20) : this.cloudHeight.floatValue();
    }

    public float[] getSunriseColor(float timeOfDay, float partialTick) {
        float g;
        float[] colorsSunriseSunset = new float[4];
        float f2 = 0.4f;
        float r = MathHelper.cos((float)(timeOfDay * 3.141593f * 2.0f)) - 0.0f;
        if (r >= (g = -0.0f) - f2 && r <= g + f2) {
            float f5 = (r - g) / f2 * 0.5f + 0.5f;
            float f6 = 1.0f - (1.0f - MathHelper.sin((float)(f5 * 3.141593f))) * 0.99f;
            f6 *= f6;
            colorsSunriseSunset[0] = f5 * 0.3f + 0.1f;
            colorsSunriseSunset[1] = f5 * f5 * 0.7f + 0.2f;
            colorsSunriseSunset[2] = f5 * f5 * 0.7f + 0.2f;
            colorsSunriseSunset[3] = f6;
            return colorsSunriseSunset;
        }
        return null;
    }

    public Vec3 getFogColor(World world, double x, double y, double z, float celestialAngle, float partialTick) {
        float b;
        float g;
        float r;
        float f2 = MathHelper.cos((float)(celestialAngle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
        f2 = MathHelper.clamp((float)f2, (float)0.0f, (float)1.0f);
        if (Colorizers.fog.isEnabled()) {
            int x1 = MathHelper.floor((double)x);
            int y1 = MathHelper.floor((double)y);
            int z1 = MathHelper.floor((double)z);
            int color = Colorizers.fog.getColor((WorldSource)world, x1, y1, z1);
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        } else {
            int x1 = 0x8080A0;
            r = (float)(x1 >> 16 & 0xFF) / 255.0f;
            g = (float)(x1 >> 8 & 0xFF) / 255.0f;
            b = (float)(x1 & 0xFF) / 255.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return Vec3.getTempVec3((double)(r *= f2 * 0.94f + 0.06f), (double)(g *= f2 * 0.94f + 0.06f), (double)(b *= f2 * 0.91f + 0.09f));
    }
}

