/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.particle.ParticleDispatcher;
import net.minecraft.client.entity.particle.ParticleFirefly;
import net.minecraft.client.gui.achievements.data.AchievementPage;
import net.minecraft.client.gui.achievements.data.AchievementPages;
import net.minecraft.client.gui.hud.component.ComponentAnchor;
import net.minecraft.client.gui.hud.component.HudComponent;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.HudComponents;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.gui.hud.component.layout.LayoutAbsolute;
import net.minecraft.client.gui.hud.component.layout.LayoutSnap;
import net.minecraft.client.render.texture.stitcher.AtlasStitcher;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.worldtype.WorldTypeFXDispatcher;
import net.minecraft.client.sound.SoundRepository;
import teamport.aether.AetherMod;
import teamport.aether.AetherRemoteResourceDownloaderThread;
import teamport.aether.achievements.AchievementPageAether;
import teamport.aether.achievements.AetherAchievements;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.command.AetherCommand;
import teamport.aether.ducks.IBlockAether;
import teamport.aether.entity.AetherMobInfoRegistry;
import teamport.aether.game_settings.AetherGameSettings;
import teamport.aether.gui.ComponentBossBar;
import teamport.aether.gui.ComponentJumpBar;
import teamport.aether.particle.ParticleDartEnchanted;
import teamport.aether.particle.ParticleFlameAmbrosium;
import teamport.aether.particle.ParticleFlameEnchanter;
import teamport.aether.particle.ParticleGoldenDust;
import teamport.aether.particle.ParticleLightningKnife;
import teamport.aether.particle.ParticlePoison;
import teamport.aether.particle.ParticleRemedy;
import teamport.aether.particle.ParticleSnowflake;
import teamport.aether.world.type.AetherWorldTypes;
import teamport.aether.world.type.WorldTypeFXAether;
import turniplabs.halplibe.helper.TextureHelper;
import turniplabs.halplibe.util.ClientStartEntrypoint;

@Environment(value=EnvType.CLIENT)
public class AetherClient
implements ClientModInitializer,
ClientStartEntrypoint {
    public static HudComponent BOSS_BAR;
    public static HudComponent JUMP_BAR;
    public static AetherRemoteResourceDownloaderThread resourceDownloaderThread;
    public static AtlasStitcher extras;

    public void beforeClientStart() {
        ParticleDispatcher dispatcher = ParticleDispatcher.getInstance();
        dispatcher.addDispatch((Object)"flameambrosium", (world, x, y, z, xa, ya, za, id) -> new ParticleFlameAmbrosium(world, x, y, z, xa, ya, za));
        dispatcher.addDispatch((Object)"flameenchanter", (world, x, y, z, xa, ya, za, id) -> new ParticleFlameEnchanter(world, x, y, z, xa, ya, za));
        dispatcher.addDispatch((Object)"lightning", (world, x, y, z, xa, ya, za, id) -> new ParticleLightningKnife(world, x, y, z, xa, ya, za));
        dispatcher.addDispatch((Object)"snowflake", (world, x, y, z, xa, ya, za, id) -> new ParticleSnowflake(world, x, y, z, xa, ya, za));
        dispatcher.addDispatch((Object)"darttrail", (world, x, y, z, xa, ya, za, id) -> new ParticleDartEnchanted(world, x, y, z, xa, ya, za));
        dispatcher.addDispatch((Object)"goldendust", (world, x, y, z, xa, ya, za, id) -> new ParticleGoldenDust(world, x, y, z, xa, ya, za));
        dispatcher.addDispatch((Object)"fireflySilver", (world, x, y, z, motionX, motionY, motionZ, data) -> new ParticleFirefly(world, x, y, z, motionX, motionY, motionZ, AetherMod.SILVER.getId()));
        dispatcher.addDispatch((Object)"poison", (world, x, y, z, xa, ya, za, id) -> new ParticlePoison(world, x, y, z, xa, ya, za));
        dispatcher.addDispatch((Object)"remedy", (world, x, y, z, xa, ya, za, id) -> new ParticleRemedy(world, x, y, z, xa, ya, za));
        SoundRepository.registerNamespace((String)"aether");
        AetherCommand.registerClientCommands();
        AetherClient.registerTextures();
    }

    public void afterClientStart() {
        Minecraft mc = Minecraft.getMinecraft();
        try {
            AetherMod.LOGGER.info("Starting Resource Download Thread...");
            resourceDownloaderThread = new AetherRemoteResourceDownloaderThread(mc.getMinecraftDir(), mc);
            resourceDownloaderThread.start();
        }
        catch (Exception exc) {
            AetherMod.LOGGER.error("Failed to start Resource Download Thread!", (Throwable)exc);
        }
        this.setupCustomBlockLight();
        AetherMobInfoRegistry.init();
        AetherGameSettings.init();
        WorldTypeFXDispatcher.getInstance().addDispatch(new WorldTypeFXAether(AetherWorldTypes.AETHER_EXTENDED).setCloudHeight(8.0f).setHasAurora(true).setHasGround(false));
        WorldTypeFXDispatcher.getInstance().addDispatch(new WorldTypeFXAether(AetherWorldTypes.AETHER_DEFAULT).setCloudHeight(8.0f).setHasAurora(true).setHasGround(false));
        WorldTypeFXDispatcher.getInstance().addDispatch(new WorldTypeFXAether(AetherWorldTypes.AETHER_SKYBLOCK).setCloudHeight(8.0f).setHasAurora(true).setHasGround(false));
        WorldTypeFXDispatcher.getInstance().addDispatch(new WorldTypeFXAether(AetherWorldTypes.AETHER_RETRO).setCloudHeight(8.0f).setHasAurora(true).setHasGround(false));
    }

    public void setupCustomBlockLight() {
        IBlockAether.of(AetherBlocks.CARVED_STONE_LIGHT).better_with_aether$setEmissionOverride(0);
        IBlockAether.of(AetherBlocks.CARVED_STONE_LIGHT_LOCKED).better_with_aether$setEmissionOverride(0);
        IBlockAether.of(AetherBlocks.CARVED_ANGELIC_LIGHT).better_with_aether$setEmissionOverride(0);
        IBlockAether.of(AetherBlocks.CARVED_ANGELIC_LIGHT_LOCKED).better_with_aether$setEmissionOverride(0);
        IBlockAether.of(AetherBlocks.CARVED_HELLFIRE_LIGHT).better_with_aether$setEmissionOverride(0);
        IBlockAether.of(AetherBlocks.CARVED_HELLFIRE_LIGHT_LOCKED).better_with_aether$setEmissionOverride(0);
    }

    public void onInitializeClient() {
        AetherMod.LOGGER.info("AetherMod client initialized.");
    }

    public static void initAchievementsPage() {
        AchievementPageAether page = new AchievementPageAether("aether", AetherBlocks.GRASS_AETHER.getDefaultStack());
        page.addAchievement(AetherAchievements.HOSTILE_PARADISE, 0, 0);
        page.addAchievement(AetherAchievements.SHOOTER, 1, -3);
        page.addAchievement(AetherAchievements.HIT_ZEPHYR, 2, -5);
        page.addAchievement(AetherAchievements.POISON, -1, -3);
        page.addAchievement(AetherAchievements.REMEDY, -2, -5);
        page.addAchievement(AetherAchievements.BOUNCE, -2, 0);
        page.addAchievement(AetherAchievements.GOLD_CLOUD, -3, -2);
        page.addAchievement(AetherAchievements.PARACHUTE, -4, 0);
        page.addAchievement(AetherAchievements.PHYG, -2, 2);
        page.addAchievement(AetherAchievements.MOA, -4, 2);
        page.addAchievement(AetherAchievements.ENCHANTER, 5, -1);
        page.addAchievement(AetherAchievements.WEVE_GOT_HOSTILES, 2, 1);
        page.addAchievement(AetherAchievements.SENTRY_DEPLOYED, 0, 3);
        page.addAchievement(AetherAchievements.BRONZE, 0, 5);
        page.addAchievement(AetherAchievements.ITS_A_TRAP, 2, 3);
        page.addAchievement(AetherAchievements.SILVER, 2, 5);
        page.addAchievement(AetherAchievements.ICE_DEFLECT, 4, 3);
        page.addAchievement(AetherAchievements.GOLD, 4, 5);
        page.addAchievement(AetherAchievements.SKYROOT, 3, 0);
        page.addAchievement(AetherAchievements.AMBROSIUM, 4, 1);
        page.addAchievement(AetherAchievements.HEALING_STONE, 6, 1);
        page.addAchievement(AetherAchievements.GRAVITITE, 3, -2);
        page.addAchievement(AetherAchievements.ALL_MUSIC_DISCS, 4, -4);
        page.addAchievement(AetherAchievements.MAX_LIFE, 6, 6);
        page.addAchievement(AetherAchievements.ALL_ACCESSORY_TYPES, -2, 6);
        AchievementPages.register((AchievementPage)page);
    }

    public static void registerHUDComponents() {
        BOSS_BAR = HudComponents.register((HudComponent)new ComponentBossBar("aether.boss.bar", (Layout)new LayoutAbsolute(0.5f, 0.0f, ComponentAnchor.TOP_CENTER)));
        JUMP_BAR = HudComponents.register((HudComponent)new ComponentJumpBar("aether.wing.bar", (Layout)new LayoutSnap(HudComponents.HEALTH_BAR, ComponentAnchor.TOP_LEFT, ComponentAnchor.BOTTOM_LEFT)));
        ((HudComponentMovable)HudComponents.OXYGEN_BAR).setLayout((Layout)new LayoutSnap(HudComponents.ARMOR_BAR, ComponentAnchor.TOP_LEFT, ComponentAnchor.BOTTOM_LEFT));
    }

    public static void registerTextures() {
        for (AtlasStitcher stitcher : TextureRegistry.stitcherMap.values()) {
            try {
                TextureHelper.initializeAllFiles((String)"aether", (AtlasStitcher)stitcher, (int)Integer.MAX_VALUE);
            }
            catch (Exception e) {
                AetherMod.LOGGER.error("Failed to initialize texture files!", (Throwable)e);
            }
        }
    }

    static {
        extras = TextureRegistry.register((String)"extras", (AtlasStitcher)new AtlasStitcher("textures/extras", true, false, null));
    }
}

