/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.blocks.dungeon;

import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.block.BlockLogicRotatable;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemLabel;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import teamport.aether.achievements.AetherAchievements;
import teamport.aether.entity.monster.mimic.MimicEntry;
import teamport.aether.entity.monster.mimic.MimicRegistry;
import teamport.aether.entity.monster.mimic.MobMimic;
import teamport.aether.entity.tile.TileEntityMimic;
import teamport.aether.helper.ParticleMaker;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class BlockLogicChestMimic
extends BlockLogicRotatable {
    private double dx;
    private double dy;
    private double dz;
    public static final int COLOR_MASK = 240;

    public BlockLogicChestMimic(Block<?> block, Material material) {
        super(block, material);
        block.withEntity(TileEntityMimic::new);
    }

    public void onBlockPlacedByMob(World world, int x, int y, int z, @NonNull Side side, Mob mob, double xPlaced, double yPlaced) {
        int metadata = world.getBlockMetadata(x, y, z);
        Direction direction = mob.getHorizontalPlacementDirection(side).getOpposite();
        metadata = BlockLogicChestMimic.getMetaWithDirection(metadata, direction);
        ItemStack stack = mob.getHeldItem();
        if (stack != null && stack.getItem() instanceof ItemBlock) {
            CompoundTag loot = stack.getData().getCompound("loot");
            TileEntityMimic chest = new TileEntityMimic();
            chest.readFromNBT(loot);
            world.setTileEntity(x, y, z, (TileEntity)chest);
        }
        world.setBlockMetadataWithNotify(x, y, z, metadata);
    }

    public int getPlacedBlockMetadata(@Nullable Player player, ItemStack stack, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        return stack.getMetadata();
    }

    public static int getMetaWithDirection(int meta, Direction direction) {
        if (direction == null) {
            return meta;
        }
        return meta & 0xF0 | direction.ordinal() & 3;
    }

    public @Nullable ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        if (tileEntity == null) {
            tileEntity = world.getTileEntity(x, y, z);
        }
        switch (dropCause) {
            case EXPLOSION: 
            case PISTON_CRUSH: {
                return this.dropAsDefeatedMimic(world, x, y, z, meta, tileEntity);
            }
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                return this.dropAsBlock(meta, tileEntity);
            }
            case WORLD: 
            case PROPER_TOOL: 
            case IMPROPER_TOOL: {
                if (world.getDifficulty().canHostileMobsSpawn()) break;
                return this.dropAsDefeatedMimic(world, x, y, z, meta, tileEntity);
            }
        }
        this.triggerMimic(world, x, y, z, meta, tileEntity);
        return null;
    }

    public void onActivatorInteract(World world, int x, int y, int z, TileEntityActivator activator, Direction direction) {
        MobMimic mimic = this.summonMimic(world, x, y, z);
        this.moveToSafe(world, (Mob)mimic, x, y, z, 0.0f, 0.0f);
        world.setBlockWithNotify((int)Math.round(this.dx), (int)Math.round(this.dy), (int)Math.round(this.dz), 0);
        world.playSoundEffect(null, SoundCategory.ENTITY_SOUNDS, this.dx, this.dy, this.dz, "random.door_open", 1.0f, 0.5f);
        ParticleMaker.spawnParticle(world, "explode", this.dx, this.dy, this.dz, 0.0, 0.0, 0.0, 0);
    }

    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        ItemStack stack;
        TileEntity tileEntity;
        ItemStack held = player.getHeldItem();
        if (held != null && held.getItem() instanceof ItemLabel && (tileEntity = world.getTileEntity(x, y, z)) instanceof TileEntityMimic) {
            ((TileEntityMimic)tileEntity).setCustomName(held.getCustomName(), (byte)Math.max(held.getCustomColor(), 0));
            return true;
        }
        if (!(player.gamemode != Gamemode.creative || (stack = player.getHeldItem()) != null && stack.getItem().hasTag(ItemTags.PREVENT_CREATIVE_MINING))) {
            player.displayChestScreen(BlockLogicChest.getInventory((World)world, (int)x, (int)y, (int)z), (double)x, (double)y, (double)z);
            return true;
        }
        if (world.getDifficulty().canHostileMobsSpawn()) {
            if (!EnvironmentHelper.isClientWorld()) {
                MobMimic mimic = this.summonMimic(world, x, y, z);
                this.moveToSafe(world, (Mob)mimic, x, y, z, player.xRot - 180.0f, player.xRot - 180.0f);
            }
            player.triggerAchievement((Stat)AetherAchievements.ITS_A_TRAP);
            world.setBlockWithNotify(x, y, z, 0);
            world.playSoundEffect((Entity)player, SoundCategory.ENTITY_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.door_open", 1.0f, 0.5f);
            if (!EnvironmentHelper.isServerEnvironment()) {
                ParticleMaker.spawnParticle(world, "explode", this.dx, this.dy, this.dz, 0.0, 0.0, 0.0, 0);
            }
            return true;
        }
        player.displayChestScreen(BlockLogicChest.getInventory((World)world, (int)x, (int)y, (int)z), (double)x, (double)y, (double)z);
        return true;
    }

    private @NonNull ItemStack[] dropAsDefeatedMimic(World world, int x, int y, int z, int meta, TileEntity tileEntity) {
        if (tileEntity instanceof TileEntityMimic) {
            ((TileEntityMimic)tileEntity).dropContentForced(world, x, y, z);
        }
        MimicEntry variant = MimicRegistry.getMimicVariantByMimicChest(this.id(), meta & 0xF0);
        return new ItemStack[]{new ItemStack(variant.getChestID(), 1, variant.getChestMetadata())};
    }

    private @Nullable MobMimic summonMimic(World world, int x, int y, int z) {
        int metadata = world.getBlockMetadata(x, y, z);
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        return this.summonMimic(world, tileEntity, x, y, z, metadata);
    }

    private void triggerMimic(World world, int x, int y, int z, int meta, TileEntity tileEntity) {
        Player player;
        MobMimic mimic = this.summonMimic(world, tileEntity, x, y, z, meta);
        world.playSoundEffect((Entity)mimic, SoundCategory.ENTITY_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.door_open", 1.0f, 0.5f);
        world.setBlockWithNotify(x, y, z, 0);
        if (!EnvironmentHelper.isServerEnvironment()) {
            ParticleMaker.spawnParticle(world, "explode", (double)x + 0.5, (double)y + 1.0, (double)z + 0.5, 0.0, 0.0, 0.0, 0);
        }
        if ((player = world.getClosestPlayer((double)x, (double)y, (double)z, 16.0)) != null) {
            this.moveToSafe(world, (Mob)mimic, x, y, z, player.xRot - 180.0f, player.xRot - 180.0f);
            player.triggerAchievement((Stat)AetherAchievements.ITS_A_TRAP);
        } else {
            Objects.requireNonNull(mimic).absMoveTo((double)x + 0.5, y, (double)z + 0.5, mimic.yRot, mimic.xRot);
        }
    }

    private @Nullable MobMimic summonMimic(World world, TileEntity tileEntity, int x, int y, int z, int metadata) {
        if (EnvironmentHelper.isClientWorld()) {
            return null;
        }
        List<ItemStack> chestInv = this.getAndClearInventory(tileEntity);
        MimicEntry variant = MimicRegistry.getMimicVariantByMimicChest(this.id(), metadata & 0xF0);
        MobMimic mimic = new MobMimic(world);
        mimic.setPos((double)x + 0.5, y, (double)z + 0.5);
        mimic.setLoot(chestInv);
        mimic.spawnInit();
        mimic.setSkinVariant(variant.getMimicVariant());
        mimic.setBlockData(variant.getMimicChestID(), variant.getMimicChestMetadata());
        if (tileEntity instanceof TileEntityMimic) {
            mimic.setNickname(((TileEntityMimic)tileEntity).getNickName());
            mimic.setChatColor(((TileEntityMimic)tileEntity).getChatColor());
        }
        world.entityJoinedWorld((Entity)mimic);
        return mimic;
    }

    private @NonNull ItemStack[] dropAsBlock(int meta, TileEntity tileEntity) {
        ItemStack result = new ItemStack(this.block, 1, meta & 0xF0);
        CompoundTag data = result.getData();
        CompoundTag mimicData = new CompoundTag();
        if (tileEntity != null) {
            if (tileEntity instanceof TileEntityMimic) {
                TileEntityMimic mimicEntity = (TileEntityMimic)tileEntity;
                result.setCustomColor(mimicEntity.getChatColor());
                result.setCustomName(mimicEntity.getNickName());
            }
            tileEntity.writeToNBT(mimicData);
        }
        data.putCompound("loot", mimicData);
        result.setData(data);
        return new ItemStack[]{result};
    }

    private List<ItemStack> getAndClearInventory(TileEntity tileEntity) {
        if (!(tileEntity instanceof TileEntityMimic)) {
            return Collections.emptyList();
        }
        Container inv = (Container)tileEntity;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            stacks.add(inv.getItem(i));
            inv.setItem(i, null);
        }
        return stacks;
    }

    private void moveToSafe(World world, Mob mob, int x, int y, int z, float yRot, float xRot) {
        if (this.isSafe(world, x - 1, y, z)) {
            mob.moveTo((double)((float)x - 0.5f), (double)y, (double)((float)z + 0.5f), yRot, xRot);
            this.dx = (float)x - 0.5f;
            this.dy = y;
            this.dz = (float)z + 0.5f;
            return;
        }
        if (this.isSafe(world, x + 1, y, z)) {
            mob.moveTo((double)((float)x + 1.5f), (double)y, (double)((float)z + 0.5f), yRot, xRot);
            this.dx = (float)x + 1.5f;
            this.dy = y;
            this.dz = (float)z + 0.5f;
            return;
        }
        if (this.isSafe(world, x, y, z - 1)) {
            mob.moveTo((double)((float)x + 0.5f), (double)y, (double)((float)z - 0.5f), yRot, xRot);
            this.dx = (float)x + 0.5f;
            this.dy = y;
            this.dz = (float)z - 0.5f;
            return;
        }
        if (this.isSafe(world, x, y, z + 1)) {
            mob.moveTo((double)((float)x + 0.5f), (double)y, (double)((float)z + 1.5f), yRot, xRot);
            this.dx = (float)x + 0.5f;
            this.dy = (double)y + 1.0;
            this.dz = z;
            return;
        }
        mob.moveTo((double)((float)x + 0.5f), (double)y + 1.0, (double)((float)z + 0.5f), yRot, xRot);
        this.dx = (float)x + 0.5f;
        this.dy = (double)y + 1.0;
        this.dz = (float)z + 0.5f;
    }

    private boolean isSafe(World world, int x, int y, int z) {
        return !world.isBlockNormalCube(x, y, z) && !world.isBlockNormalCube(x, y + 1, z);
    }
}

