/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.blocks.terrain;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.data.gamerule.GameRule;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import teamport.aether.blocks.AetherBlockTags;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.items.AetherItems;
import teamport.aether.world.AetherDimension;

public class BlockLogicGrassAether
extends BlockLogic
implements IBonemealable {
    public final Block<?> dirt;

    public BlockLogicGrassAether(Block<?> block, Block<?> dirt) {
        super(block, Material.grass);
        block.setTicking(true);
        this.dirt = dirt;
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (!world.isClientSide) {
            if (world.getBlockLightValue(x, y + 1, z) < 4 && Blocks.lightBlock[world.getBlockId(x, y + 1, z)] > 2) {
                if (rand.nextInt(4) != 0) {
                    return;
                }
                world.setBlockWithNotify(x, y, z, this.dirt.id());
            } else if (world.getBlockLightValue(x, y + 1, z) >= 9) {
                int idToSpawn;
                for (idToSpawn = 0; idToSpawn < 4; ++idToSpawn) {
                    int z1;
                    int y1;
                    int x1 = x + rand.nextInt(3) - 1;
                    if (!world.isBlockLoaded(x1, y1 = y + rand.nextInt(5) - 3, z1 = z + rand.nextInt(3) - 1) || world.getBlockId(x1, y1, z1) != this.dirt.id() || world.getBlockLightValue(x1, y1 + 1, z1) < 4 || Blocks.lightBlock[world.getBlockId(x1, y1 + 1, z1)] > 2) continue;
                    world.setBlockWithNotify(x1, y1, z1, this.block.id());
                }
                if (((Boolean)world.getGameRuleValue((GameRule)GameRules.DO_SEASONAL_GROWTH)).booleanValue() && world.getBlockId(x, y + 1, z) == 0 && rand.nextInt(512) == 0 && world.dimension == AetherDimension.getAether()) {
                    int r = rand.nextInt(400);
                    idToSpawn = r < 26 ? AetherBlocks.FLOWER_PURPLE.id() : (r < 41 ? AetherBlocks.FLOWER_WHITE.id() : AetherBlocks.TALLGRASS_AETHER.id());
                    world.setBlockWithNotify(x, y + 1, z, idToSpawn);
                }
            }
        }
    }

    public boolean onBonemealUsed(ItemStack itemstack, Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (!world.isClientSide) {
            Random random = world.rand;
            block0: for (int i = 0; i < 128; ++i) {
                int rand;
                Object plantBlock;
                int x = blockX;
                int y = blockY + 1;
                int z = blockZ;
                for (int j = 0; j < i / 16; ++j) {
                    int blockBelowId = world.getBlockId(x += random.nextInt(3) - 1, (y += (random.nextInt(3) - 1) * random.nextInt(3) / 2) - 1, z += random.nextInt(3) - 1);
                    Block blockBelow = Blocks.blocksList[blockBelowId];
                    if (blockBelow == null || !blockBelow.hasTag(AetherBlockTags.GROWS_AETHER_FLOWERS)) continue block0;
                }
                if (!world.isAirBlock(x, y, z) || !(plantBlock = (rand = random.nextInt(10)) < 8 ? AetherBlocks.TALLGRASS_AETHER : (rand < 9 ? AetherBlocks.FLOWER_PURPLE : AetherBlocks.FLOWER_WHITE)).canBlockStay(world, x, y, z)) continue;
                world.setBlockWithNotify(x, y, z, plantBlock.id());
            }
            if (player.getGamemode().consumeBlocks()) {
                --itemstack.stackSize;
            }
        }
        player.swingItem();
        return false;
    }

    public void onBlockPlacedByMob(World world, int x, int y, int z, @NonNull Side side, Mob mob, double xPlaced, double yPlaced) {
        world.setBlockMetadataWithNotify(x, y, z, 1);
    }

    public int getPlacedBlockMetadata(@Nullable Player player, ItemStack stack, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        return 1;
    }

    public void onBlockDestroyedByPlayer(World world, int x, int y, int z, Side side, int meta, Player player, Item item) {
        ItemStack heldItem = player.getHeldItem();
        if (heldItem != null && heldItem.getItem().equals(AetherItems.TOOL_SHOVEL_SKYROOT) && meta == 0 && player.getGamemode().consumeBlocks()) {
            this.harvestBlock(world, player, x, y, z, 1, world.getTileEntity(x, y, z));
        }
    }

    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                return new ItemStack[]{new ItemStack((IItemConvertible)this)};
            }
        }
        return new ItemStack[]{new ItemStack(this.dirt)};
    }
}

