/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.compat.waila;

import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import teamport.aether.entity.tile.TileEntityEnchanter;
import toufoumaster.btwaila.BTWaila;
import toufoumaster.btwaila.gui.components.AdvancedInfoComponent;
import toufoumaster.btwaila.tooltips.TileTooltip;
import toufoumaster.btwaila.util.ProgressBarOptions;
import toufoumaster.btwaila.util.TextureOptions;

public class EnchanterTooltip
extends TileTooltip<TileEntityEnchanter> {
    public void initTooltip() {
        this.addClass(TileEntityEnchanter.class);
    }

    public void drawAdvancedTooltip(TileEntityEnchanter enchanter, AdvancedInfoComponent advancedInfoComponent) {
        ItemStack input = enchanter.getItem(0);
        ItemStack fuel = enchanter.getItem(1);
        ItemStack output = enchanter.getItem(2);
        ProgressBarOptions options = new ProgressBarOptions(0, String.format("%s%s%s ", TextFormatting.LIME, BTWaila.translator.translateKey("aether.tooltip.enchanter.progress"), TextFormatting.RESET), true, true, new TextureOptions(0xFFFFFF, TextureRegistry.getTexture((String)"aether:extras/enchanter_bg")), new TextureOptions(0xFFFFFF, TextureRegistry.getTexture((String)"aether:extras/enchanter_fg")));
        advancedInfoComponent.drawProgressBarTextureWithText(enchanter.getProcessProgressScaled(100), 100, options, -12);
        advancedInfoComponent.drawStringWithShadow(String.format(BTWaila.translator.translateKey("aether.tooltip.machine.energy"), enchanter.getCurrentEnergyTime() / 20), 0);
        ItemStack[] stacks = new ItemStack[]{input, fuel, output};
        advancedInfoComponent.drawItemList(stacks, 0);
    }
}

