/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.animal.aerwhale;

import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.MobFlying;
import net.minecraft.core.entity.animal.AmbientCreature;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class MobAerwhale
extends MobFlying
implements AmbientCreature {
    private double motionYaw;
    private double motionPitch;
    private long checkTime = 0L;
    private double checkX = 0.0;
    private double checkY = 0.0;
    private double checkZ = 0.0;
    private boolean isStuckWarning = false;
    private static final int DATA_MOTION_YAW = 16;
    private static final int DATA_MOTION_PITCH = 17;

    public MobAerwhale(World world) {
        super(world);
        this.setSize(0.1f, 0.1f);
        this.viewScale = 100.0;
        this.textureIdentifier = NamespaceID.getPermanent((String)"aether", (String)"aerwhale");
        this.fireImmune = true;
        this.moveSpeed = 0.5f;
        this.yRot = 360.0f * this.random.nextFloat();
        this.xRot = 90.0f * this.random.nextFloat() - 45.0f;
        this.ignoreFrustumCheck = true;
    }

    public boolean hurt(Entity attacker, int damage, DamageType type) {
        return false;
    }

    public void updateAI() {
        double[] distances = new double[]{this.openSpace(0.0f, 0.0f), this.openSpace(45.0f, 0.0f), this.openSpace(0.0f, 45.0f), this.openSpace(-45.0f, 0.0f), this.openSpace(0.0f, -45.0f)};
        int longest = 0;
        for (int distance = 1; distance < 5; ++distance) {
            if (!(distances[distance] > distances[longest])) continue;
            longest = distance;
        }
        switch (longest) {
            case 0: {
                if (distances[0] == 50.0) {
                    this.motionYaw *= (double)0.9f;
                    this.motionPitch *= (double)0.9f;
                    if (this.y > 225.0) {
                        this.motionPitch -= 2.0;
                        break;
                    }
                    if (!(this.y < 180.0)) break;
                    this.motionPitch += 2.0;
                    break;
                }
                this.xRot = -this.xRot;
                this.yRot = -this.yRot;
                break;
            }
            case 1: {
                this.motionYaw += 5.0;
                break;
            }
            case 2: {
                this.motionPitch -= 5.0;
                break;
            }
            case 3: {
                this.motionYaw -= 5.0;
                break;
            }
            case 4: {
                this.motionPitch += 5.0;
            }
        }
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(16, (Object)0, Integer.class);
        this.entityData.define(17, (Object)0, Integer.class);
    }

    public void lerpPosAndRot() {
        if (this.newPosRotationIncrements > 0) {
            double lerpYRot;
            double lerpXD = this.x + (this.newPosX - this.x) / (double)this.newPosRotationIncrements;
            double lerpYD = this.y + (this.newPosY - this.y) / (double)this.newPosRotationIncrements;
            double lerpZD = this.z + (this.newPosZ - this.z) / (double)this.newPosRotationIncrements;
            double lerpXRot = this.newRotationPitch - (double)this.xRot;
            for (lerpYRot = this.newRotationYaw - (double)this.yRot; lerpYRot < -180.0; lerpYRot += 360.0) {
            }
            while (lerpYRot >= 180.0) {
                lerpYRot -= 360.0;
            }
            this.yRot = (float)((double)this.yRot + lerpYRot / (double)this.newPosRotationIncrements);
            this.xRot = (float)((double)this.xRot + lerpXRot / (double)this.newPosRotationIncrements);
            --this.newPosRotationIncrements;
            this.setPos(lerpXD, lerpYD, lerpZD);
            this.setRot(this.yRot, this.xRot);
        }
    }

    public void tick() {
        if (!EnvironmentHelper.isClientWorld()) {
            this.updateAI();
            this.checkForBeingStuck();
            this.motionYaw += (double)(2.0f * this.random.nextFloat() - 1.0f);
            this.motionPitch += (double)(2.0f * this.random.nextFloat() - 1.0f);
            this.entityData.set(16, (Object)Float.floatToIntBits((float)this.motionYaw));
            this.entityData.set(17, (Object)Float.floatToIntBits((float)this.motionPitch));
        } else {
            this.lerpPosAndRot();
            this.motionYaw = Float.intBitsToFloat(this.entityData.getInt(16));
            this.motionPitch = Float.intBitsToFloat(this.entityData.getInt(17));
        }
        this.xRot = (float)((double)this.xRot + 0.1 * this.motionPitch);
        this.yRot = (float)((double)this.yRot + 0.1 * this.motionYaw);
        if (this.xRot < -60.0f) {
            this.xRot = -60.0f;
        }
        if (this.xRot > 60.0f) {
            this.xRot = 60.0f;
        }
        this.xRot = (float)((double)this.xRot * 0.99);
        this.xd += 0.005 * Math.cos((double)this.yRot / 180.0 * Math.PI) * Math.cos((double)this.xRot / 180.0 * Math.PI);
        this.yd += 0.005 * Math.sin((double)this.xRot / 180.0 * Math.PI);
        this.zd += 0.005 * Math.sin((double)this.yRot / 180.0 * Math.PI) * Math.cos((double)this.xRot / 180.0 * Math.PI);
        this.xd *= 0.98;
        this.yd *= 0.98;
        this.zd *= 0.98;
        int floorX = MathHelper.floor((double)this.x);
        int floorY = MathHelper.floor((double)this.bb.minY);
        int floorZ = MathHelper.floor((double)this.z);
        if (this.world != null) {
            if (this.xd > 0.0 && this.world.getBlockId(floorX + 1, floorY, floorZ) != 0) {
                this.xd = -this.xd;
                this.motionYaw -= 10.0;
            } else if (this.xd < 0.0 && this.world.getBlockId(floorX - 1, floorY, floorZ) != 0) {
                this.xd = -this.xd;
                this.motionYaw += 10.0;
            }
            if (this.yd > 0.0 && this.world.getBlockId(floorX, floorY + 1, floorZ) != 0) {
                this.yd = -this.yd;
                this.motionPitch -= 10.0;
            } else if (this.yd < 0.0 && this.world.getBlockId(floorX, floorY - 1, floorZ) != 0) {
                this.yd = -this.yd;
                this.motionPitch += 10.0;
            }
            if (this.zd > 0.0 && this.world.getBlockId(floorX, floorY, floorZ + 1) != 0) {
                this.zd = -this.zd;
                this.motionYaw -= 10.0;
            } else if (this.zd < 0.0 && this.world.getBlockId(floorX, floorY, floorZ - 1) != 0) {
                this.zd = -this.zd;
                this.motionYaw += 10.0;
            }
        }
        this.move(this.xd, this.yd, this.zd);
    }

    public String getLivingSound() {
        return "aether:mob.aerwhale.call";
    }

    public String getHurtSound() {
        return "aether:mob.aerwhale.call";
    }

    public String getDeathSound() {
        return "aether:mob.aerwhale.call";
    }

    public float getSoundVolume() {
        return 3.0f;
    }

    public int getMaxSpawnedInChunk() {
        return 1;
    }

    public void spawnInit() {
        if (this.world != null && this.world.getBlockId((int)(this.x + 0.5), (int)(this.y + 25.0), (int)(this.z + 0.5)) == 0) {
            this.moveTo(this.x, this.y + 25.0, this.z, this.yRot, 0.0f);
        }
    }

    public boolean canSpawnHere() {
        int x = MathHelper.floor((double)this.x);
        int y = MathHelper.floor((double)this.bb.minY);
        int z = MathHelper.floor((double)this.z);
        return this.world != null && this.world.checkIfAABBIsClear(this.bb) && this.world.getCollidingSolidBlockBoundingBoxes((Entity)this, this.bb).isEmpty() && !this.world.isAABBInMaterial(this.bb, Material.water) && this.world.getFullBlockLightValue(x, y, z) > 8;
    }

    public double openSpace(float rotationyRotOffset, float rotationPitchOffset) {
        float f9;
        float f6;
        double d3;
        float f5;
        if (this.world == null) {
            return 50.0;
        }
        float yRot = this.yRot + rotationyRotOffset;
        float pitch = this.xRot + rotationPitchOffset;
        Vec3 vec3d = Vec3.getTempVec3((double)this.x, (double)this.y, (double)this.z);
        float f3 = MathHelper.cos((float)(-yRot * 0.01745329f - 3.141593f));
        float f4 = MathHelper.sin((float)(-yRot * 0.01745329f - 3.141593f));
        float f7 = f4 * (f5 = MathHelper.cos((float)(-pitch * 0.01745329f)));
        Vec3 vec3d1 = vec3d.add((double)f7 * (d3 = 50.0), (double)(f6 = MathHelper.sin((float)(-pitch * 0.01745329f))) * d3, (double)(f9 = f3 * f5) * d3);
        HitResult movingobjectposition = this.world.checkBlockCollisionBetweenPoints(vec3d, vec3d1, true);
        if (movingobjectposition == null) {
            return 50.0;
        }
        if (movingobjectposition.hitType == HitResult.HitType.TILE) {
            double i = (double)movingobjectposition.x - this.x;
            double j = (double)movingobjectposition.y - this.y;
            double k = (double)movingobjectposition.z - this.z;
            return Math.sqrt(i * i + j * j + k * k);
        }
        return 50.0;
    }

    public void checkForBeingStuck() {
        long currTime = System.currentTimeMillis();
        if (currTime > this.checkTime + 3000L) {
            double diffX = this.x - this.checkX;
            double diffY = this.y - this.checkY;
            double diffZ = this.z - this.checkZ;
            double distanceTravelled = Math.sqrt(diffX * diffX + diffY * diffY + diffZ * diffZ);
            if (distanceTravelled < 3.0) {
                if (!this.isStuckWarning) {
                    this.isStuckWarning = true;
                } else {
                    this.remove();
                }
            }
            this.checkX = this.x;
            this.checkY = this.y;
            this.checkZ = this.z;
            this.checkTime = currTime;
        }
    }
}

