/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.boss.slider;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.Entity;
import org.lwjgl.opengl.GL11;
import teamport.aether.entity.boss.slider.MobBossSlider;

@Environment(value=EnvType.CLIENT)
public class MobRendererSlider
extends MobRenderer<MobBossSlider> {
    public MobRendererSlider(ModelBase model, float shadowSize) {
        super(model, shadowSize);
        this.setArmorModel(model);
        this.shadowSize = 0.0f;
    }

    public void renderPreview(Tessellator tessellator, MobBossSlider slider, double x, double y, double z, float yaw, float partialTick) {
        GL11.glPushMatrix();
        GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
        this.bindTexture("/assets/aether/textures/entity/boss_slider/slider_awake.png");
        super.renderPreview(tessellator, (Entity)slider, x, y + 0.5, z, yaw, partialTick);
        GL11.glPopMatrix();
    }

    public boolean setEyeBrightness(MobBossSlider slider, int renderPass) {
        if (renderPass != 0) {
            return false;
        }
        if (slider.isAwake() && !slider.doingSlam()) {
            if (slider.isAngry()) {
                this.bindTexture("/assets/aether/textures/entity/boss_slider/slider_awake_red_glow.png");
            } else {
                this.bindTexture("/assets/aether/textures/entity/boss_slider/slider_awake_glow.png");
            }
        } else if (slider.isAngry()) {
            this.bindTexture("/assets/aether/textures/entity/boss_slider/slider_sleep_red_glow.png");
        } else {
            this.bindTexture("/assets/aether/textures/entity/boss_slider/slider_sleep_glow.png");
        }
        float f1 = (1.0f - slider.getBrightness(1.0f)) * 0.5f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f1);
        return true;
    }

    public void setupScale(MobBossSlider slider, float partialTick) {
        if (slider.getDeformX() > 0.01f) {
            GL11.glRotatef((float)(slider.getDeformX() * -30.0f), (float)slider.getDeformY(), (float)0.0f, (float)slider.getDeformZ());
        }
    }

    public boolean prepareArmor(MobBossSlider slider, int renderPass, float partialTick) {
        return this.setEyeBrightness(slider, renderPass);
    }
}

