/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.aechorplant;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBase;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class ModelAechorPlant
extends ModelBase {
    private static final int PETALS = 10;
    private static final int THORNS = 4;
    private static final int STAMENS = 3;
    private float sinage;
    private float sinage2;
    private float size = 1.0f;
    private final Cube[] petal = new Cube[10];
    private final Cube[] leaf = new Cube[10];
    private final Cube[] stamen;
    private final Cube[] stamen2;
    private final Cube[] thorn;
    private final Cube stem;
    private final Cube head;
    private final float pie;

    public ModelAechorPlant() {
        this(0.0f);
    }

    public ModelAechorPlant(float f) {
        this(f, 0.0f);
    }

    public ModelAechorPlant(float f, float f1) {
        int i;
        this.pie = 6.283186f;
        for (i = 0; i < 10; ++i) {
            this.petal[i] = new Cube(0, 0);
            if (i % 2 == 0) {
                this.petal[i] = new Cube(29, 3);
                this.petal[i].addBox(-4.0f, -1.0f, -12.0f, 8, 0, 9, f);
                this.petal[i].setRotationPoint(0.0f, 1.0f + f1, 0.0f);
            } else {
                this.petal[i].addBox(-4.0f, -1.0f, -13.0f, 8, 0, 10, f);
                this.petal[i].setRotationPoint(0.0f, 1.0f + f1, 0.0f);
            }
            this.leaf[i] = new Cube(38, 13);
            this.leaf[i].addBox(-2.0f, -1.0f, -9.5f, 4, 1, 8, f);
            this.leaf[i].setRotationPoint(0.0f, 1.0f + f1, 0.0f);
        }
        this.stamen = new Cube[3];
        this.stamen2 = new Cube[3];
        for (i = 0; i < 3; ++i) {
            this.stamen[i] = new Cube(36, 13);
            this.stamen[i].addBox(0.0f, -9.0f, -1.5f, 1, 6, 0, f);
            this.stamen[i].setRotationPoint(0.0f, 1.0f + f1, 0.0f);
        }
        for (i = 0; i < 3; ++i) {
            this.stamen2[i] = new Cube(32, 15);
            this.stamen2[i].addBox(0.0f, -8.1f, -2.0f, 1, 0, 1, f);
            this.stamen2[i].setRotationPoint(0.0f, 1.0f + f1, 0.0f);
        }
        this.head = new Cube(0, 12);
        this.head.addBox(-3.0f, -3.0f, -3.0f, 6, 2, 6, f + 0.75f);
        this.head.setRotationPoint(0.0f, 1.0f + f1, 0.0f);
        this.stem = new Cube(24, 13);
        this.stem.addBox(-1.0f, 0.0f, -1.0f, 2, 6, 2, f);
        this.stem.setRotationPoint(0.0f, 1.0f + f1, 0.0f);
        this.thorn = new Cube[4];
        for (i = 0; i < 4; ++i) {
            this.thorn[i] = new Cube(32, 13);
            this.thorn[i].setRotationPoint(0.0f, 1.0f + f1, 0.0f);
        }
        this.thorn[0].addBox(-1.75f, 1.25f, -1.0f, 1, 0, 1, f);
        this.thorn[1].addBox(-1.0f, 2.25f, 0.75f, 1, 0, 1, f);
        this.thorn[2].addBox(0.75f, 1.25f, 0.0f, 1, 0, 1, f);
        this.thorn[3].addBox(0.0f, 2.25f, -1.75f, 1, 0, 1, f);
    }

    public void render(float f, float f1, float f2, float f3, float f4, float f5) {
        int i;
        this.setAngles(f4);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)1.2f, (float)0.0f);
        GL11.glScalef((float)this.size, (float)this.size, (float)this.size);
        for (i = 0; i < 10; ++i) {
            this.petal[i].render(f5);
            this.leaf[i].render(f5);
        }
        for (i = 0; i < 3; ++i) {
            this.stamen[i].render(f5);
            this.stamen2[i].render(f5);
        }
        this.head.render(f5);
        this.stem.render(f5);
        for (i = 0; i < 4; ++i) {
            this.thorn[i].render(f5);
        }
        GL11.glPopMatrix();
    }

    private void setAngles(float f4) {
        Cube var10000;
        int i;
        this.head.xRot = 0.0f;
        this.head.yRot = f4 / 57.29578f;
        float boff = this.sinage2;
        this.stem.yRot = this.head.yRot;
        this.stem.y = boff * 0.5f;
        for (i = 0; i < 4; ++i) {
            this.thorn[i].yRot = this.head.yRot;
            this.thorn[i].y = boff * 0.5f;
        }
        for (i = 0; i < 10; ++i) {
            this.petal[i].xRot = i % 2 == 0 ? -0.25f : -0.4125f;
            var10000 = this.petal[i];
            var10000.xRot += this.sinage;
            this.petal[i].yRot = this.head.yRot;
            var10000 = this.petal[i];
            var10000.yRot += this.pie / 10.0f * (float)i;
            this.leaf[i].xRot = i % 2 == 0 ? 0.1f : 0.2f;
            var10000 = this.leaf[i];
            var10000.xRot += this.sinage * 0.75f;
            this.leaf[i].yRot = this.head.yRot + this.pie / 10.0f / 2.0f;
            var10000 = this.leaf[i];
            var10000.yRot += this.pie / 10.0f * (float)i;
            this.petal[i].y = boff;
            this.leaf[i].y = boff;
        }
        for (i = 0; i < 3; ++i) {
            this.stamen[i].xRot = 0.2f + (float)i / 15.0f;
            this.stamen[i].yRot = this.head.yRot + 0.1f;
            var10000 = this.stamen[i];
            var10000.yRot += this.pie / 3.0f * (float)i;
            var10000 = this.stamen[i];
            var10000.xRot += this.sinage * 0.4f;
            this.stamen2[i].xRot = 0.2f + (float)i / 15.0f;
            this.stamen2[i].yRot = this.head.yRot + 0.1f;
            var10000 = this.stamen2[i];
            var10000.yRot += this.pie / 3.0f * (float)i;
            var10000 = this.stamen2[i];
            var10000.xRot += this.sinage * 0.4f;
            this.stamen[i].y = boff + this.sinage * 2.0f;
            this.stamen2[i].y = boff + this.sinage * 2.0f;
        }
        this.head.y = boff + this.sinage * 2.0f;
    }

    public void setSinage(float sinage) {
        this.sinage = sinage;
    }

    public void setSinage2(float sinage2) {
        this.sinage2 = sinage2;
    }

    public void setSize(float size) {
        this.size = size;
    }
}

