/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.swet;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;
import teamport.aether.entity.monster.swet.MobSwet;

@Environment(value=EnvType.CLIENT)
public class MobRendererSwet
extends MobRenderer<MobSwet> {
    public final ModelBase scaleAmount;

    public MobRendererSwet(ModelBase modelbase, ModelBase modelbase1, float shadowsize) {
        super(modelbase, shadowsize);
        this.scaleAmount = modelbase1;
    }

    private boolean renderSlimePassModel(int renderPass) {
        if (renderPass == 0) {
            this.setArmorModel(this.scaleAmount);
            GL11.glEnable((int)2977);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            return true;
        }
        if (renderPass == 1) {
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return false;
        }
        return false;
    }

    public void scaleSlime(MobSwet entityswets, float partialTick) {
        float f2 = 1.0f;
        float f1 = 1.0f;
        float f3 = 1.5f;
        double yd = MathHelper.lerp((double)entityswets.getYdO(), (double)entityswets.yd, (double)partialTick);
        if (!entityswets.onGround) {
            if (yd > 0.85) {
                f1 = 1.425f;
                f2 = 0.575f;
            } else if (yd < -0.85) {
                f1 = 0.575f;
                f2 = 1.425f;
            } else {
                float f4 = (float)yd * 0.5f;
                f1 += f4;
                f2 -= f4;
            }
        }
        if (entityswets.passenger != null) {
            f3 = 1.5f + (entityswets.passenger.bbWidth + entityswets.passenger.bbHeight) * 0.75f;
        }
        f1 = MathHelper.clamp((float)f1, (float)0.1f, (float)10.0f);
        f2 = MathHelper.clamp((float)f2, (float)0.1f, (float)10.0f);
        f3 = MathHelper.clamp((float)f3, (float)0.1f, (float)10.0f);
        GL11.glScalef((float)(f2 * f3), (float)(f1 * f3), (float)(f2 * f3));
    }

    public void setupScale(MobSwet entity, float partialTick) {
        this.scaleSlime(entity, partialTick);
    }

    public boolean prepareArmor(MobSwet entity, int renderPass, float partialTick) {
        return this.renderSlimePassModel(renderPass);
    }
}

