/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.projectile;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.projectile.Projectile;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import teamport.aether.entity.projectile.ProjectileAether;
import teamport.aether.helper.ParticleMaker;

public abstract class ProjectileElementBase
extends Projectile
implements ProjectileAether {
    protected int bounceCount = 0;
    private static final int MAX_BOUNCES = 20;
    private static final String[] DEFAULT_PARTICLES = new String[]{"explode"};

    protected ProjectileElementBase(World world) {
        super(world);
        this.initProjectile();
    }

    protected ProjectileElementBase(World world, Mob owner) {
        super(world, owner);
        this.initProjectile();
    }

    protected ProjectileElementBase(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.initProjectile();
    }

    public void initProjectile() {
        this.damage = 2;
        this.defaultGravity = 0.0f;
        this.setSize(1.0f, 1.0f);
    }

    public void tick() {
        super.tick();
        if (this.world == null) {
            return;
        }
        int xFloor = MathHelper.floor((double)this.x);
        int yFloor = MathHelper.floor((double)this.y);
        int zFloor = MathHelper.floor((double)this.z);
        if (this.xd > 0.0 && this.world.getBlockId(xFloor + 1, yFloor, zFloor) != 0 || this.xd < 0.0 && this.world.getBlockId(xFloor - 1, yFloor, zFloor) != 0) {
            this.xd = -this.xd;
            this.bounceSound();
            ++this.bounceCount;
        }
        if (this.yd > 0.0 && this.world.getBlockId(xFloor, yFloor + 1, zFloor) != 0 || this.yd < 0.0 && this.world.getBlockId(xFloor, yFloor - 1, zFloor) != 0) {
            this.yd = -this.yd;
            this.bounceSound();
            ++this.bounceCount;
        }
        if (this.zd > 0.0 && this.world.getBlockId(xFloor, yFloor, zFloor + 1) != 0 || this.zd < 0.0 && this.world.getBlockId(xFloor, yFloor, zFloor - 1) != 0) {
            this.zd = -this.zd;
            this.bounceSound();
            ++this.bounceCount;
        }
        if (!this.world.isClientSide && this.bounceCount >= 20) {
            this.doExplosion();
            this.remove();
        }
    }

    public void bounceSound() {
        if (this.world != null) {
            this.world.playSoundAtEntity(null, (Entity)this, "random.explode", 0.1f, 2.0f);
        }
    }

    public void doExplosion() {
        ProjectileElementBase.doExplosionHelper(this.world, (Entity)this, DEFAULT_PARTICLES, "random.explode", null, SoundCategory.WORLD_SOUNDS, 0.25f);
    }

    protected static void doExplosionHelper(World world, Entity entity, String[] particles, @Nullable String soundPath, @Nullable Mob target, SoundCategory soundCategory, float volume) {
        if (world == null) {
            return;
        }
        Entity usedEntity = target == null ? entity : target;
        for (int particle = 0; particle < 16; ++particle) {
            double xParticle = usedEntity.x + world.rand.nextDouble() - world.rand.nextDouble() * 0.375;
            double yParticle = usedEntity.y + 0.5 + world.rand.nextDouble() - world.rand.nextDouble() * 0.375;
            double zParticle = usedEntity.z + world.rand.nextDouble() - world.rand.nextDouble() * 0.375;
            ParticleMaker.spawnParticle(world, particles[world.rand.nextInt(particles.length)], xParticle, yParticle, zParticle, 0.0, 0.0, 0.0, 0);
        }
        if (soundPath != null) {
            world.playSoundEffect(null, soundCategory, usedEntity.x, usedEntity.y, usedEntity.z, soundPath, volume, (1.3f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.2f) * 0.7f);
        } else {
            world.playBlockSoundEffect(null, usedEntity.x, usedEntity.y, usedEntity.z, Blocks.ICE, EnumBlockSoundEffectType.MINE);
        }
    }

    public void onHit(HitResult hitResult) {
        if (this.world == null || this.world.isClientSide) {
            return;
        }
        if (hitResult.side != null) {
            switch (hitResult.side) {
                case BOTTOM: 
                case TOP: {
                    this.yd = -this.yd * 1.0;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    this.zd = -this.zd * 1.0;
                    break;
                }
                case WEST: 
                case EAST: {
                    this.xd = -this.xd * 1.0;
                }
            }
            ++this.bounceCount;
        }
    }

    public void afterTick() {
        this.x += this.xd;
        this.y += this.yd;
        this.z += this.zd;
        this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / Math.PI);
        if (this.isInWater()) {
            this.waterTick();
        }
        this.setPos(this.x, this.y, this.z);
    }

    public void readAdditionalSaveData(@NonNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.bounceCount = tag.getInteger("bounceCount");
    }

    public void addAdditionalSaveData(@NonNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("bounceCount", this.bounceCount);
    }

    public boolean isPickable() {
        return true;
    }

    public float getPickRadius() {
        return 1.0f;
    }

    public boolean hurt(Entity entity, int damage, DamageType type) {
        return false;
    }

    protected static Entity getEntity(Class<? extends ProjectileElementBase> clazz, World world, double x, double y, double z, int meta, boolean hasVelocity, double xd, double yd, double zd, Entity owner) {
        ProjectileElementBase element;
        try {
            element = clazz.getDeclaredConstructor(World.class).newInstance(world);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        element.setPos(x, y, z);
        if (hasVelocity) {
            element.setHeading(xd, yd, zd, 1.0f, 0.0f);
        }
        if (owner instanceof Mob) {
            element.owner = (Mob)owner;
        }
        return element;
    }
}

