/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.projectile;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import teamport.aether.entity.boss.sunspirit.MobBossSunspirit;
import teamport.aether.entity.monster.fireminion.MobFireMinion;
import teamport.aether.entity.projectile.AetherProjectileDeathMessages;
import teamport.aether.entity.projectile.ProjectileElementBase;
import teamport.aether.helper.ParticleMaker;

public class ProjectileElementFire
extends ProjectileElementBase
implements AetherProjectileDeathMessages {
    private static final String[] PARTICLES = new String[]{"explode", "flame", "lava"};

    public static Entity getEntity(World world, double x, double y, double z, int meta, boolean hasVelocity, double xd, double yd, double zd, Entity owner) {
        return ProjectileElementFire.getEntity(ProjectileElementFire.class, world, x, y, z, meta, hasVelocity, xd, yd, zd, owner);
    }

    public ProjectileElementFire(World world) {
        super(world);
        this.initProjectile();
        this.projectileSpeed = 0.25f;
    }

    public ProjectileElementFire(World world, Mob owner) {
        super(world, owner);
        this.initProjectile();
        this.projectileSpeed = 0.25f;
    }

    @Override
    public void tick() {
        if (this.world == null) {
            return;
        }
        for (int j = 0; j < 1; ++j) {
            ParticleMaker.spawnParticle(this.world, "flame", this.x, this.y + 0.5, this.z, this.world.rand.nextFloat() * 0.25f * (float)(this.world.rand.nextBoolean() ? -1 : 1), 0.0, this.world.rand.nextFloat() * 0.25f * (float)(this.world.rand.nextBoolean() ? -1 : 1), 0);
        }
        super.tick();
    }

    @Override
    public void doExplosion() {
        ProjectileElementFire.doExplosionHelper(this.world, (Entity)this, PARTICLES, "mob.ghast.fireball", null, SoundCategory.WORLD_SOUNDS, 0.25f);
    }

    @Override
    public void onHit(HitResult hitResult) {
        if (!(this.world == null || this.world.isClientSide || hitResult.entity instanceof MobBossSunspirit || hitResult.entity instanceof ProjectileElementBase || hitResult.entity instanceof MobFireMinion || !(hitResult.entity instanceof Mob))) {
            hitResult.entity.hurt((Entity)this.owner, this.damage, DamageType.FIRE);
            hitResult.entity.maxFireTicks = 200;
            hitResult.entity.remainingFireTicks = 200;
            this.remove();
            return;
        }
        super.onHit(hitResult);
    }
}

