/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.projectile;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import teamport.aether.entity.boss.sunspirit.MobBossSunspirit;
import teamport.aether.entity.monster.fireminion.MobFireMinion;
import teamport.aether.entity.projectile.AetherProjectileDeathMessages;
import teamport.aether.entity.projectile.ProjectileElementBase;
import teamport.aether.helper.ParticleMaker;

public class ProjectileElementIce
extends ProjectileElementBase
implements AetherProjectileDeathMessages {
    private static final String[] PARTICLES = new String[]{"block", "snowshovel"};

    public static Entity getEntity(World world, double x, double y, double z, int meta, boolean hasVelocity, double xd, double yd, double zd, Entity owner) {
        return ProjectileElementIce.getEntity(ProjectileElementIce.class, world, x, y, z, meta, hasVelocity, xd, yd, zd, owner);
    }

    public ProjectileElementIce(World world) {
        super(world);
        this.initProjectile();
    }

    public ProjectileElementIce(World world, Mob owner) {
        super(world, owner);
        this.initProjectile();
    }

    @Override
    public void tick() {
        if (this.world == null) {
            return;
        }
        for (int j = 0; j < 2; ++j) {
            if (this.random.nextInt(5) != 0) continue;
            ParticleMaker.spawnParticle(this.world, "snowflake", this.x, this.y + 0.5, this.z, this.world.rand.nextFloat() * 0.25f * (float)(this.world.rand.nextBoolean() ? -1 : 1), 0.0, this.world.rand.nextFloat() * 0.25f * (float)(this.world.rand.nextBoolean() ? -1 : 1), 0);
        }
        super.tick();
    }

    @Override
    public void bounceSound() {
        if (this.world != null) {
            this.world.playSoundAtEntity(null, (Entity)this, "step.permafrost", 2.0f, 1.0f);
        }
    }

    @Override
    public void doExplosion() {
        ProjectileElementIce.doExplosionHelper(this.world, (Entity)this, PARTICLES, null, null, null, 0.25f);
    }

    @Override
    public void onHit(HitResult hitResult) {
        if (this.world != null && !this.world.isClientSide && hitResult.entity != null && !(hitResult.entity instanceof ProjectileElementBase)) {
            if (hitResult.entity instanceof MobBossSunspirit) {
                if (this.owner instanceof Player) {
                    hitResult.entity.hurt((Entity)this, this.damage, DamageType.GENERIC);
                    this.doExplosion();
                    this.remove();
                    return;
                }
                super.onHit(hitResult);
                return;
            }
            if (hitResult.entity instanceof MobFireMinion) {
                if (this.owner instanceof Player) {
                    hitResult.entity.hurt((Entity)this, 100, DamageType.GENERIC);
                    this.doExplosion();
                    this.remove();
                    return;
                }
                super.onHit(hitResult);
                return;
            }
            if (hitResult.entity instanceof Mob) {
                hitResult.entity.hurt((Entity)this.owner, this.damage, DamageType.GENERIC);
                this.remove();
                return;
            }
        }
        super.onHit(hitResult);
    }

    @Override
    public boolean hurt(Entity entity, int damage, DamageType type) {
        if (this.world != null && !this.world.isClientSide && entity != null) {
            Vec3 lookAngle;
            if (entity instanceof Player) {
                this.owner = (Player)entity;
            }
            if ((lookAngle = entity.getLookAngle()) == null) {
                this.owner = null;
                return false;
            }
            this.setHeading(lookAngle.x, lookAngle.y, lookAngle.z, 0.5f, 0.0f);
            this.bounceCount = 18;
            return true;
        }
        return false;
    }
}

