/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.projectile;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLightning;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.Projectile;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import teamport.aether.AetherMod;
import teamport.aether.entity.projectile.AetherProjectileDeathMessages;
import teamport.aether.entity.projectile.ProjectileAether;
import teamport.aether.helper.ParticleMaker;
import teamport.aether.items.AetherItems;

public class ProjectileKnifeLightning
extends Projectile
implements ProjectileAether,
AetherProjectileDeathMessages {
    public ProjectileKnifeLightning(World world) {
        super(world);
    }

    public ProjectileKnifeLightning(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.modelItem = AetherItems.TOOL_KNIFE_LIGHTNING;
    }

    public ProjectileKnifeLightning(World world, Player owner) {
        super(world, (Mob)owner);
    }

    public void initProjectile() {
        this.damage = 6;
        this.defaultGravity = 0.03f;
        this.defaultProjectileSpeed = 0.99f;
    }

    public void onHit(HitResult hitResult) {
        if (this.world == null) {
            return;
        }
        if (hitResult.entity != null) {
            hitResult.entity.hurt((Entity)this.owner, this.damage, AetherMod.LIGHTNING);
            if (!this.world.isClientSide) {
                this.world.entityJoinedWorld((Entity)new EntityLightning(hitResult.entity.world, hitResult.entity.x, hitResult.entity.y, hitResult.entity.z));
            }
            this.doEffect();
            this.remove();
        }
        if (hitResult.hitType == HitResult.HitType.TILE) {
            if (!this.world.isClientSide) {
                this.world.entityJoinedWorld((Entity)new EntityLightning(this.world, (double)hitResult.x + (double)hitResult.side.getOffsetX(), (double)hitResult.y + (double)hitResult.side.getOffsetY(), (double)hitResult.z + (double)hitResult.side.getOffsetZ()));
            }
            this.doEffect();
            this.remove();
        }
    }

    public void doEffect() {
        int j;
        if (this.world == null) {
            return;
        }
        for (j = 0; j < 8; ++j) {
            ParticleMaker.spawnParticle(this.world, "item", this.x, this.y, this.z, this.world.rand.nextDouble(), this.world.rand.nextDouble(), this.world.rand.nextDouble(), AetherItems.TOOL_KNIFE_LIGHTNING.id);
        }
        for (j = 0; j < 16; ++j) {
            ParticleMaker.spawnParticle(this.world, "lightning", this.x, this.y, this.z, this.world.rand.nextDouble() * 0.25 * (double)(this.world.rand.nextBoolean() ? -1 : 1), this.world.rand.nextDouble() * 0.25 * -1.0, this.world.rand.nextDouble() * 0.25 * (double)(this.world.rand.nextBoolean() ? -1 : 1), 0);
        }
    }

    public static Entity getEntity(World world, double x, double y, double z, int meta, boolean hasVelocity, double xd, double yd, double zd, Entity owner) {
        ProjectileKnifeLightning knife = new ProjectileKnifeLightning(world, x, y, z);
        if (hasVelocity) {
            knife.setHeading(xd, yd, zd, 1.0f, 0.0f);
        }
        if (owner instanceof Mob) {
            knife.owner = (Mob)owner;
        }
        return knife;
    }
}

