/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.renderer;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;
import teamport.aether.entity.projectile.ProjectileDart;

@Environment(value=EnvType.CLIENT)
public class EntityRendererDart
extends EntityRenderer<ProjectileDart> {
    public void render(Tessellator tessellator, ProjectileDart dart, double x, double y, double z, float yaw, float partialTick) {
        this.bindTexture("/assets/aether/textures/entity/darts.png");
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)(dart.yRotO + (dart.yRot - dart.yRotO) * partialTick - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(dart.xRotO + (dart.xRot - dart.xRotO) * partialTick), (float)0.0f, (float)0.0f, (float)1.0f);
        int dartType = dart.getDartType();
        float bodyMinU = 0.0f;
        float bodyMaxU = 0.5f;
        float bodyMinV = (float)(dartType * 10) / 32.0f;
        float bodyMaxV = (float)(5 + dartType * 10) / 32.0f;
        float tailMinU = 0.0f;
        float tailMaxU = 0.15625f;
        float tailMinV = (float)(5 + dartType * 10) / 32.0f;
        float tailMaxV = (float)(10 + dartType * 10) / 32.0f;
        float scale = 0.05625f;
        GL11.glEnable((int)32826);
        float shakeAmount = (float)dart.getShake() - partialTick;
        if (shakeAmount > 0.0f) {
            float shakeAngle = -MathHelper.sin((float)(shakeAmount * 3.0f)) * shakeAmount;
            GL11.glRotatef((float)shakeAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glRotatef((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glTranslatef((float)-4.0f, (float)0.0f, (float)0.0f);
        GL11.glNormal3f((float)scale, (float)0.0f, (float)0.0f);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-7.0, -2.0, -2.0, (double)tailMinU, (double)tailMinV);
        tessellator.addVertexWithUV(-7.0, -2.0, 2.0, (double)tailMaxU, (double)tailMinV);
        tessellator.addVertexWithUV(-7.0, 2.0, 2.0, (double)tailMaxU, (double)tailMaxV);
        tessellator.addVertexWithUV(-7.0, 2.0, -2.0, (double)tailMinU, (double)tailMaxV);
        tessellator.draw();
        GL11.glNormal3f((float)(-scale), (float)0.0f, (float)0.0f);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-7.0, 2.0, -2.0, (double)tailMinU, (double)tailMinV);
        tessellator.addVertexWithUV(-7.0, 2.0, 2.0, (double)tailMaxU, (double)tailMinV);
        tessellator.addVertexWithUV(-7.0, -2.0, 2.0, (double)tailMaxU, (double)tailMaxV);
        tessellator.addVertexWithUV(-7.0, -2.0, -2.0, (double)tailMinU, (double)tailMaxV);
        tessellator.draw();
        for (int i = 0; i < 8; ++i) {
            GL11.glRotatef((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)scale);
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(-8.0, -2.0, 0.0, (double)bodyMinU, (double)bodyMinV);
            tessellator.addVertexWithUV(8.0, -2.0, 0.0, (double)bodyMaxU, (double)bodyMinV);
            tessellator.addVertexWithUV(8.0, 2.0, 0.0, (double)bodyMaxU, (double)bodyMaxV);
            tessellator.addVertexWithUV(-8.0, 2.0, 0.0, (double)bodyMinU, (double)bodyMaxV);
            tessellator.draw();
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }
}

