/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.tile;

import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.font.FontRendererDefault;
import net.minecraft.client.render.font.SF;
import net.minecraft.client.render.model.ModelSign;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.client.render.tileentity.TileEntityRendererSign;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicSign;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.enums.EnumSignPicture;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import org.jspecify.annotations.NonNull;
import org.lwjgl.opengl.GL11;
import teamport.aether.entity.tile.TileEntitySignSkyroot;

public class TileEntityRendererSignSkyroot
extends TileEntityRenderer<TileEntitySignSkyroot> {
    private final @NonNull StringBuilder builder = new StringBuilder();
    private final ModelSign modelSign = new ModelSign();
    private final Minecraft mc = Minecraft.getMinecraft();
    private final TileEntityRendererSign.BufferedTextMeshRenderer textMeshRenderer = new TileEntityRendererSign.BufferedTextMeshRenderer();
    private static final FontRenderer FONT_RENDERER = new FontRendererDefault();
    private final String[] signColorTextures = new String[16];
    private String defaultSignTexture = "MissingNo";
    private Color defaultSignColor;

    public TileEntityRendererSignSkyroot() {
        this.defaultSignColor = DyeColor.PURPLE.color;
        Arrays.fill(this.signColorTextures, "MissingNo");
    }

    public TileEntityRendererSignSkyroot setColoredTexture(int colorID, String texturePath) {
        this.signColorTextures[colorID] = texturePath;
        return this;
    }

    public TileEntityRendererSignSkyroot setDefaultTexture(String texturePath, Color defaultColor) {
        this.defaultSignTexture = texturePath;
        this.defaultSignColor = defaultColor;
        return this;
    }

    private static float getAngleFromMeta(int meta) {
        float angle;
        switch (meta & 0xF) {
            case 2: {
                angle = 180.0f;
                break;
            }
            case 3: {
                angle = 0.0f;
                break;
            }
            case 4: {
                angle = 90.0f;
                break;
            }
            default: {
                angle = -90.0f;
            }
        }
        return angle;
    }

    public void doRender(@NonNull Tessellator t, @NonNull TileEntitySignSkyroot tileEntity, double x, double y, double z, float partialTick) {
        int colorSign;
        Block block = tileEntity.getBlock();
        if (block == null || !(block.getLogic() instanceof BlockLogicSign)) {
            return;
        }
        GL11.glEnable((int)32826);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        int meta = tileEntity.getBlockMeta();
        float angle = TileEntityRendererSignSkyroot.getAngleFromMeta(meta);
        if (((BlockLogicSign)block.getLogic()).isFreeStanding) {
            angle = (float)((meta & 0xF) * 360) / 16.0f;
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)1.0f, (float)0.0f);
            this.modelSign.signStick.visible = true;
        } else {
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.3125f, (float)-0.4375f);
            this.modelSign.signStick.visible = false;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)0.6666667f, (float)-0.6666667f, (float)-0.6666667f);
        if (Block.hasLogicClass((Block)block, IPainted.class)) {
            DyeColor dyeColor = ((IPainted)block.getLogic()).fromMetadata(meta);
            colorSign = dyeColor.color.getARGB();
            this.loadTexture(this.signColorTextures[dyeColor.blockMeta]);
        } else {
            colorSign = this.defaultSignColor.getARGB();
            this.loadTexture(this.defaultSignTexture);
        }
        GL11.glDisable((int)3042);
        this.modelSign.render();
        GL11.glPopMatrix();
        this.drawSignPicture(tileEntity, colorSign);
        this.drawSignText(t, tileEntity);
        GL11.glPopMatrix();
        GL11.glDisable((int)32826);
    }

    protected void drawSignPicture(TileEntitySignSkyroot tileEntity, int colorSign) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)0.0f, (float)0.33545f, (float)0.04375f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        EnumSignPicture picture = tileEntity.getPicture();
        if (picture != null && picture != EnumSignPicture.NONE) {
            TileEntityRendererSignSkyroot.drawTexturedModalRect(colorSign, TextureRegistry.getTexture((String)picture.getTextureKey()));
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    protected void drawSignText(Tessellator t, TileEntitySignSkyroot tileEntity) {
        FontRenderer sr = FONT_RENDERER;
        float lightLevel = !LightmapHelper.isLightmapEnabled() && !this.mc.isFullbrightEnabled() ? this.mc.currentWorld.getLightBrightness(tileEntity.x, tileEntity.y, tileEntity.z) : 1.0f;
        float lightOffset = 0.0f;
        if (tileEntity.isGlowing()) {
            lightLevel = 1.0f;
            lightOffset = 96.0f;
            if (LightmapHelper.isLightmapEnabled()) {
                LightmapHelper.setLightmapCoord((int)LightmapHelper.getLightmapCoord((int)15, (int)15));
            }
        }
        GL11.glPushMatrix();
        float scale2 = 0.011111113f;
        GL11.glTranslatef((float)0.0f, (float)0.33333334f, (float)0.043333333f);
        GL11.glScalef((float)scale2, (float)(-scale2), (float)scale2);
        GL11.glDepthMask((boolean)false);
        int color = Colors.allSignColors[tileEntity.getColor().id].getARGB();
        int r = (int)MathHelper.clamp((float)((float)Color.redFromInt((int)color) * lightLevel + lightOffset), (float)0.0f, (float)255.0f);
        int g = (int)MathHelper.clamp((float)((float)Color.greenFromInt((int)color) * lightLevel + lightOffset), (float)0.0f, (float)255.0f);
        int b = (int)MathHelper.clamp((float)((float)Color.blueFromInt((int)color) * lightLevel + lightOffset), (float)0.0f, (float)255.0f);
        color = Color.intToIntARGB((int)0, (int)r, (int)g, (int)b);
        CharSequence line1 = tileEntity.signText[0];
        CharSequence line2 = tileEntity.signText[1];
        CharSequence line3 = tileEntity.signText[2];
        CharSequence line4 = tileEntity.signText[3];
        switch (tileEntity.lineBeingEdited) {
            case 0: {
                this.builder.setLength(0);
                line1 = this.builder.append("\u00a7+\u00a7f> \u00a7-").append(line1).append("\u00a7+\u00a7f <\u00a7-");
                break;
            }
            case 1: {
                this.builder.setLength(0);
                line2 = this.builder.append("\u00a7+\u00a7f> \u00a7-").append(line2).append("\u00a7+\u00a7f <\u00a7-");
                break;
            }
            case 2: {
                this.builder.setLength(0);
                line3 = this.builder.append("\u00a7+\u00a7f> \u00a7-").append(line3).append("\u00a7+\u00a7f <\u00a7-");
                break;
            }
            case 3: {
                this.builder.setLength(0);
                line4 = this.builder.append("\u00a7+\u00a7f> \u00a7-").append(line4).append("\u00a7+\u00a7f <\u00a7-");
            }
        }
        int y = -tileEntity.signText.length * 5;
        if (tileEntity.isGlowing() && (Integer)this.mc.gameSettings.fancyGraphics.value >= 1) {
            this.textMeshRenderer.render(sr, t, line1, line2, line3, line4, 0, y, SF.setOutlined((long)SF.setColor((long)0L, (int)color)));
        } else {
            this.textMeshRenderer.render(sr, t, line1, line2, line3, line4, 0, y, SF.setColor((long)0L, (int)color));
        }
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawTexturedModalRect(int color, @NonNull IconCoordinate coordinate) {
        coordinate.parentAtlas.bind();
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(color, 128);
        tessellator.addVertexWithUV(-0.5, 0.25, 0.0, coordinate.getIconUMin(), coordinate.getIconVMin());
        tessellator.addVertexWithUV(-0.5, -0.25, 0.0, coordinate.getIconUMin(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(0.5, -0.25, 0.0, coordinate.getIconUMax(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(0.5, 0.25, 0.0, coordinate.getIconUMax(), coordinate.getIconVMin());
        tessellator.draw();
    }

    public void tick() {
        this.textMeshRenderer.tick();
    }

    public void onWorldChanged(World world) {
        this.textMeshRenderer.flushCaches();
    }

    public boolean isVisible(@NonNull TileEntitySignSkyroot tileEntity, @NonNull ICamera camera, float partialTick) {
        return camera.getFrustum().isVisible(AABB.getTemporaryBB((double)tileEntity.x, (double)tileEntity.y, (double)tileEntity.z, (double)((double)tileEntity.x + 1.0), (double)((double)tileEntity.y + 1.0), (double)((double)tileEntity.z + 1.0)), partialTick);
    }
}

