/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.gui.guidebook.freezer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.SearchableGuidebookSection;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.collection.Pair;
import net.minecraft.core.util.helper.MathHelper;
import teamport.aether.AetherRecipes;
import teamport.aether.gui.guidebook.freezer.RecipePageFreezer;
import teamport.aether.recipe.RecipeEntryAetherMachine;

@Environment(value=EnvType.CLIENT)
public class GuidebookSectionFreezer
extends SearchableGuidebookSection {
    public final List<GuidebookPage> pages = new ArrayList<GuidebookPage>();
    private Pair<String, List<GuidebookPage>> filteredPages = null;

    public GuidebookSectionFreezer(String translationKey, ItemStack tabIcon, int bgColor, int fgColor) {
        super(translationKey, tabIcon, bgColor, fgColor);
        this.reloadRecipes();
    }

    public List<GuidebookPage> searchPages(SearchQuery query) {
        if (this.filteredPages != null && Objects.equals(this.filteredPages.getLeft(), query.rawQuery)) {
            return (List)this.filteredPages.getRight();
        }
        List<RecipeEntryAetherMachine> filteredRecipes = new ArrayList<RecipeEntryAetherMachine>();
        ArrayList<RecipeEntryAetherMachine> allRecipes = new ArrayList<RecipeEntryAetherMachine>(AetherRecipes.FREEZER.getAllRecipes());
        allRecipes.removeIf(Objects::isNull);
        GuidebookSectionFreezer.filterRecipe(query, allRecipes, filteredRecipes);
        filteredRecipes = GuidebookSectionFreezer.moveRepairablesToBack(filteredRecipes);
        ArrayList<GuidebookPage> theFilteredPages = new ArrayList<GuidebookPage>();
        int filteredRecipeSize = filteredRecipes.size();
        int filteredPageCount = MathHelper.ceilInt((int)filteredRecipeSize, (int)6);
        for (int i = 0; i < filteredPageCount; ++i) {
            int j = i * 6;
            ArrayList<RecipeEntryAetherMachine> recipes = new ArrayList<RecipeEntryAetherMachine>(filteredRecipes.subList(Math.min(j, filteredRecipeSize), Math.min(j + 6, filteredRecipeSize)));
            if (recipes.isEmpty()) continue;
            theFilteredPages.add((GuidebookPage)new RecipePageFreezer((GuidebookSection)this, recipes));
        }
        this.filteredPages = Pair.of((Object)query.rawQuery, theFilteredPages);
        return theFilteredPages;
    }

    public void reloadRecipes() {
        this.pages.clear();
        List<RecipeEntryAetherMachine> allRecipes = new ArrayList<RecipeEntryAetherMachine>(AetherRecipes.FREEZER.getAllRecipes());
        allRecipes.removeIf(Objects::isNull);
        int totalRecipes = allRecipes.size();
        int totalPages = MathHelper.ceilInt((int)totalRecipes, (int)6);
        allRecipes = GuidebookSectionFreezer.moveRepairablesToBack(allRecipes);
        for (int i = 0; i < totalPages; ++i) {
            int j = i * 6;
            ArrayList<RecipeEntryAetherMachine> recipes = new ArrayList<RecipeEntryAetherMachine>(allRecipes.subList(Math.min(j, totalRecipes), Math.min(j + 6, totalRecipes)));
            this.pages.add((GuidebookPage)new RecipePageFreezer((GuidebookSection)this, recipes));
        }
    }

    public static void filterRecipe(SearchQuery query, List<RecipeEntryAetherMachine> allRecipes, List<RecipeEntryAetherMachine> filteredRecipes) {
        for (RecipeEntryAetherMachine recipe : allRecipes) {
            if (!recipe.matchesQueryIgnoreExceptions(query)) continue;
            filteredRecipes.add(recipe);
        }
    }

    public static List<RecipeEntryAetherMachine> moveRepairablesToBack(List<RecipeEntryAetherMachine> recipes) {
        ArrayList<RecipeEntryAetherMachine> newRecipes = new ArrayList<RecipeEntryAetherMachine>(recipes.size());
        ArrayList<RecipeEntryAetherMachine> repairable = new ArrayList<RecipeEntryAetherMachine>();
        for (RecipeEntryAetherMachine recipe : recipes) {
            ItemStack input = ((RecipeSymbol)recipe.getInput()).getStack();
            ItemStack output = (ItemStack)recipe.getOutput();
            if (input != null && output != null && input.isItemStackDamageable() && output.isItemStackDamageable() && output.itemID == input.itemID) {
                repairable.add(recipe);
                continue;
            }
            newRecipes.add(recipe);
        }
        repairable.sort(Comparator.comparing(self -> ((RecipeSymbol)self.getInput()).getStack().getDisplayName()));
        newRecipes.addAll(repairable);
        return newRecipes;
    }

    public List<GuidebookPage> getPages() {
        return this.pages;
    }

    public List<GuidebookSection.Index> getIndices() {
        return Collections.emptyList();
    }
}

