/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.gui.guidebook.incubator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.SearchableGuidebookSection;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.collection.Pair;
import net.minecraft.core.util.helper.MathHelper;
import teamport.aether.AetherRecipes;
import teamport.aether.gui.guidebook.incubator.RecipePageIncubator;
import teamport.aether.recipe.RecipeEntryIncubator;

@Environment(value=EnvType.CLIENT)
public class GuidebookIncubatorSection
extends SearchableGuidebookSection {
    public final List<GuidebookPage> pages = new ArrayList<GuidebookPage>();
    private Pair<String, List<GuidebookPage>> filteredPages = null;
    private static final int ENTRY_PER_PAGE = 3;

    public GuidebookIncubatorSection(String translationKey, ItemStack tabIcon, int bgColor, int fgColor) {
        super(translationKey, tabIcon, bgColor, fgColor);
        this.reloadRecipes();
    }

    public void reloadRecipes() {
        this.pages.clear();
        ArrayList<RecipeEntryIncubator> allRecipes = new ArrayList<RecipeEntryIncubator>(AetherRecipes.INCUBATOR.getAllRecipes());
        allRecipes.removeIf(Objects::isNull);
        int totalRecipes = allRecipes.size();
        int totalPages = MathHelper.ceilInt((int)totalRecipes, (int)3);
        for (int i = 0; i < totalPages; ++i) {
            int j = i * 3;
            ArrayList<RecipeEntryIncubator> recipes = new ArrayList<RecipeEntryIncubator>(allRecipes.subList(Math.min(j, totalRecipes), Math.min(j + 3, totalRecipes)));
            this.pages.add((GuidebookPage)new RecipePageIncubator(this, recipes));
        }
    }

    public List<GuidebookPage> searchPages(SearchQuery searchQuery) {
        if (this.filteredPages != null && Objects.equals(this.filteredPages.getLeft(), searchQuery.rawQuery)) {
            return (List)this.filteredPages.getRight();
        }
        ArrayList<GuidebookPage> theFilteredPages = new ArrayList<GuidebookPage>();
        ArrayList<RecipeEntryIncubator> allRecipes = new ArrayList<RecipeEntryIncubator>(AetherRecipes.INCUBATOR.getAllRecipes());
        ArrayList<RecipeEntryIncubator> filteredRecipes = new ArrayList<RecipeEntryIncubator>();
        allRecipes.removeIf(Objects::isNull);
        for (RecipeEntryIncubator recipe : allRecipes) {
            if (!recipe.matchesQueryIgnoreExceptions(searchQuery)) continue;
            filteredRecipes.add(recipe);
        }
        int filteredRecipeSize = filteredRecipes.size();
        int filteredPageCount = MathHelper.ceilInt((int)filteredRecipeSize, (int)3);
        for (int i = 0; i < filteredPageCount; ++i) {
            int j = i * 3;
            ArrayList<RecipeEntryIncubator> recipes = new ArrayList<RecipeEntryIncubator>(filteredRecipes.subList(Math.min(j, filteredRecipeSize), Math.min(j + 3, filteredRecipeSize)));
            if (recipes.isEmpty()) continue;
            theFilteredPages.add((GuidebookPage)new RecipePageIncubator(this, recipes));
        }
        this.filteredPages = Pair.of((Object)searchQuery.rawQuery, theFilteredPages);
        return theFilteredPages;
    }

    public List<GuidebookPage> getPages() {
        return this.pages;
    }

    public List<GuidebookSection.Index> getIndices() {
        return Collections.emptyList();
    }
}

