/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.gui.guidebook.incubator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.guidebook.GuidebookPageManager;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.GuidebookSections;
import net.minecraft.client.gui.guidebook.RecipePage;
import net.minecraft.client.gui.guidebook.ScreenGuidebook;
import net.minecraft.client.gui.guidebook.SlotGuidebook;
import net.minecraft.client.gui.guidebook.mobs.MobInfoRegistry;
import net.minecraft.client.gui.guidebook.search.GuidebookPageSearch;
import net.minecraft.client.option.enums.DescriptionPromptEnum;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.TextureManager;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.slot.Slot;
import org.jspecify.annotations.NonNull;
import org.lwjgl.opengl.GL11;
import teamport.aether.AetherMod;
import teamport.aether.gui.guidebook.incubator.GuidebookIncubatorSection;
import teamport.aether.recipe.RecipeEntity;
import teamport.aether.recipe.RecipeEntryIncubator;

public class RecipePageIncubator
extends RecipePage<RecipeEntryIncubator> {
    private final List<SlotGuidebook> slots;
    private final TooltipElement tooltipElement;
    private final ItemElement itemElement;
    private final Map<RecipeEntryIncubator, SlotGuidebook> map;
    private static final Minecraft mc = Minecraft.getMinecraft();

    public RecipePageIncubator(GuidebookIncubatorSection section, List<RecipeEntryIncubator> recipes) {
        super((GuidebookSection)section);
        this.recipes = recipes;
        this.slots = new ArrayList<SlotGuidebook>();
        this.tooltipElement = new TooltipElement(mc);
        this.itemElement = new ItemElement(mc);
        this.map = new HashMap<RecipeEntryIncubator, SlotGuidebook>();
        this.buildSlots(recipes);
    }

    public void buildSlots(List<RecipeEntryIncubator> recipes) {
        for (RecipeEntryIncubator recipe : recipes) {
            int yOffset = 32 * (this.map.size() + 1) - 16;
            SlotGuidebook recipeSlot = new SlotGuidebook(0, 20, 2 * yOffset, (RecipeSymbol)recipe.getInput(), false, (RecipeEntryBase)recipe);
            this.map.put(recipe, recipeSlot);
            this.slots.add(recipeSlot);
        }
    }

    public void renderForeground(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.recipes.isEmpty()) {
            this.drawStringCenteredNoShadow(fr, I18n.getInstance().translateKey("guidebook.section.search.error.no_recipes"), x + 79, y + 110, -8355712);
        }
        SlotGuidebook mouseOverSlot = null;
        for (RecipeEntryIncubator recipe : this.recipes) {
            String[] description;
            String[] substrings;
            SlotGuidebook slot = this.map.get((Object)recipe);
            this.drawSlot(x + slot.x - 1, y + slot.y - 1, -1);
            if (this.getIsMouseOverSlot((Slot)slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            String entityName = (substrings = ((RecipeEntity)recipe.getOutput()).getEntity().split(":")).length > 1 ? substrings[1] : substrings[0];
            String title = RecipePageIncubator.getEntityTitle(recipe);
            StringBuilder buildTime = new StringBuilder();
            int time = Math.round((float)((Integer)recipe.getData()).intValue() / 20.0f);
            if (time >= 60) {
                time = Math.round((float)time / 60.0f);
                buildTime.append(time).append(" min");
            } else {
                buildTime.append(time).append(" sec");
            }
            String duration = buildTime.toString();
            boolean discovered = slot.getIsDiscovered((Player)RecipePageIncubator.mc.thePlayer);
            if (discovered) {
                description = RecipePageIncubator.createDescLines(fr, "aether.guidebook.section.incubator." + entityName);
            } else {
                description = RecipePageIncubator.createDescLines(fr, "aether.guidebook.section.incubator.undiscovered");
                title = new String(new char[title.length()]).replace("\u0000", "?");
                duration = new String(new char[duration.length()]).replace("\u0000", "?");
            }
            int yOffset = y + slot.y - 1 - 10;
            int xOffset = x + slot.x - 1 + 30;
            this.drawStringNoShadow(fr, title, xOffset, yOffset, 0);
            this.drawStringNoShadow(fr, "Duration: " + duration, xOffset, yOffset += 10, 0);
            yOffset += 10;
            for (String descLine : description) {
                this.drawStringNoShadow(fr, descLine, xOffset, yOffset, 0x505050);
                yOffset += 10;
            }
            this.itemElement.render(slot.getItemStack(), x + slot.x, y + slot.y, mouseOverSlot == slot, (Slot)slot);
        }
    }

    private static @NonNull String getEntityTitle(RecipeEntryIncubator recipe) {
        Class entity = EntityDispatcher.classForId((String)((RecipeEntity)recipe.getOutput()).getEntity());
        MobInfoRegistry.MobInfo mobInfo = MobInfoRegistry.getMobInfo((Class)entity);
        String translationKey = mobInfo.getNameTranslationKey();
        return "Hatch " + AetherMod.TRANSLATOR.translateKey(translationKey);
    }

    public boolean getIsMouseOverSlot(Slot slot, int x, int y, int mouseX, int mouseY) {
        return mouseX >= x + slot.x - 1 && mouseX < x + slot.x + 16 + 1 && mouseY >= y + slot.y - 1 && mouseY < y + slot.y + 16 + 1;
    }

    public void renderOverlay(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        super.renderOverlay(re, fr, x, y, mouseX, mouseY, partialTicks);
        SlotGuidebook mouseOverSlot = null;
        for (SlotGuidebook slot : this.slots) {
            if (this.getIsMouseOverSlot((Slot)slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (mouseOverSlot == null || !mouseOverSlot.hasItem()) continue;
            boolean showDescription = DescriptionPromptEnum.showDescription((Minecraft)mc);
            String str = this.tooltipElement.getTooltipText(mouseOverSlot.getItemStack(), showDescription, (Slot)mouseOverSlot);
            if (str.isEmpty()) continue;
            this.tooltipElement.render(str, mouseX, mouseY, 8, -8);
        }
    }

    public static String[] createDescLines(Font fr, String languageKey) {
        String[] words = I18n.getInstance().translateKey(languageKey).split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (fr.getStringWidth(line + " " + word) > 100) {
                lines.add(line.toString());
                line = new StringBuilder();
            }
            if (word.contains("\n")) {
                String safeWord = word.replace("\r", "");
                String[] wordParts = safeWord.split("\n");
                for (int i = 0; i < wordParts.length; ++i) {
                    if (i > 0) {
                        lines.add(line.toString());
                        line = new StringBuilder();
                    }
                    line.append(wordParts[i]).append(" ");
                }
                continue;
            }
            line.append(word).append(" ");
        }
        lines.add(line.toString());
        return lines.toArray(new String[0]);
    }

    public boolean keyTyped(char c, int key, int x, int y, int mouseX, int mouseY) {
        super.keyTyped(c, key, x, y, mouseX, mouseY);
        if (RecipePageIncubator.mc.gameSettings.keyShowRecipe.isKeyboardKey(key)) {
            SlotGuidebook hoveringSlot = null;
            for (SlotGuidebook slot : this.slots) {
                if (!this.getIsMouseOverSlot((Slot)slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "r:" + Objects.requireNonNull(hoveringSlot.getItemStack()).getDisplayName() + "!";
                GuidebookPageManager.searchQuery = SearchQuery.resolve((String)query);
                GuidebookPageSearch.searchField.setText(query);
                ScreenGuidebook.getPageManager().updatePages();
                ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
                return true;
            }
        } else if (RecipePageIncubator.mc.gameSettings.keyShowUsage.isKeyboardKey(key)) {
            SlotGuidebook hoveringSlot = null;
            for (SlotGuidebook slot : this.slots) {
                if (!this.getIsMouseOverSlot((Slot)slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "u:" + Objects.requireNonNull(hoveringSlot.getItemStack()).getDisplayName() + "!";
                GuidebookPageManager.searchQuery = SearchQuery.resolve((String)query);
                GuidebookPageSearch.searchField.setText(query);
                ScreenGuidebook.getPageManager().updatePages();
                ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
                return true;
            }
        }
        return false;
    }
}

