/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.items;

import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import sunsetsatellite.catalyst.effects.helper.HealthHelper;
import teamport.aether.AetherConfig;
import teamport.aether.achievements.AetherAchievements;

public class ItemLifeShard
extends Item {
    private static final float ADD_VOLUME = 0.4f / (float)AetherConfig.EXTRA_HEALTH;
    private static final float ADD_PITCH = 0.3f / (float)AetherConfig.EXTRA_HEALTH;

    public ItemLifeShard(String name, String namespaceId, int id) {
        super(name, namespaceId, id);
    }

    public ItemStack onUseItem(ItemStack itemstack, World world, Player player) {
        boolean canGainExtraHealth;
        int extraHealth = HealthHelper.getExtraHealth((Player)player);
        boolean canHeal = player.getHealth() < player.getMaxHealth();
        boolean bl = canGainExtraHealth = extraHealth < AetherConfig.EXTRA_HEALTH;
        if (!canHeal && !canGainExtraHealth) {
            return itemstack;
        }
        if (!itemstack.consumeItem(player)) {
            return itemstack;
        }
        if (!canGainExtraHealth) {
            player.heal(player.getMaxHealth());
            world.playSoundAtEntity((Entity)player, (Entity)player, "aether:life.shard.chime", 0.45f, 0.6f);
            return itemstack;
        }
        int gainHealth = extraHealth + 2 <= AetherConfig.EXTRA_HEALTH ? 2 : 1;
        HealthHelper.addExtraHealth((Player)player, (int)gainHealth);
        int extraHealthCapped = Math.min(extraHealth, AetherConfig.EXTRA_HEALTH);
        if (extraHealth >= AetherConfig.EXTRA_HEALTH - 2) {
            world.playSoundAtEntity((Entity)player, (Entity)player, "aether:life.shard.chime.final", 0.65f, 1.0f);
            player.triggerAchievement((Stat)AetherAchievements.MAX_LIFE);
        } else {
            world.playSoundAtEntity((Entity)player, (Entity)player, "aether:life.shard.chime", 0.45f + ADD_VOLUME * (float)extraHealthCapped, 0.9f + ADD_PITCH * (float)extraHealthCapped);
        }
        player.heal(2);
        return itemstack;
    }
}

