/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.items.accessory.trinket;

import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.Projectile;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import teamport.aether.items.AetherRepulsion;
import teamport.aether.items.accessory.IAccessoryEffects;
import teamport.aether.items.accessory.trinket.ItemShield;

public class ItemRepulsionShield
extends ItemShield
implements IAccessoryEffects {
    public ItemRepulsionShield(String translationKey, String namespaceId, int id, String name) {
        super(translationKey, namespaceId, id, name);
    }

    public void inventoryTick(ItemStack stack, World world, Entity entity, int slotId, boolean flag) {
        Player player = (Player)entity;
        int armorSlot = slotId - player.inventory.mainInventory.length;
        if (armorSlot != 6 && armorSlot != 7) {
            return;
        }
        ItemStack[] armor = player.inventory.armorInventory;
        if (armorSlot == 7 && armor[6] != null && armor[6].getItem() instanceof ItemRepulsionShield) {
            return;
        }
        double velocity = MathHelper.sqrt((double)(player.xd * player.xd + player.zd * player.zd));
        if (player.isSneaking() || player.onGround && velocity <= 0.075) {
            ((AetherRepulsion)player).aether$setRepulsion(true);
            List projectiles = world.getEntitiesWithinAABB(Projectile.class, player.bb.grow(1.25, 1.25, 1.25));
            if (!projectiles.isEmpty()) {
                for (Projectile projectile : projectiles) {
                    if (projectile.owner == player) continue;
                    projectile.xd = -projectile.xd;
                    projectile.zd = -projectile.zd;
                }
            }
        } else {
            ((AetherRepulsion)player).aether$setRepulsion(false);
        }
    }

    @Override
    public void removeEffect(Player player, ItemStack accessory) {
        ((AetherRepulsion)player).aether$setRepulsion(false);
    }
}

