/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.accessory;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import teamport.aether.items.accessory.IAccessoryEffects;

@Mixin(value={ContainerInventory.class}, remap=false)
public abstract class ContainerInventoryMixinAccessory {
    @Shadow
    public Player player;
    @Shadow
    public ItemStack[] armorInventory;
    @Shadow
    public ItemStack[] mainInventory;

    @Inject(method={"<init>(Lnet/minecraft/core/entity/player/Player;)V"}, at={@At(value="TAIL")})
    private void setNewSize(Player player, CallbackInfo ci) {
        ((ContainerInventory)this).armorInventory = new ItemStack[8];
    }

    @ModifyExpressionValue(method={"readFromNBT(Lcom/mojang/nbt/tags/ListTag;)V"}, at={@At(value="CONSTANT", args={"intValue=4"})})
    private int modifyArmourSize(int original) {
        return original + 4;
    }

    @ModifyExpressionValue(method={"getContainerSize()I"}, at={@At(value="CONSTANT", args={"intValue=4"})})
    private int modifyContainerSize(int original) {
        return this.armorInventory.length;
    }

    @Inject(method={"decrementAnimations()V"}, at={@At(value="TAIL")})
    private void addArmorAnimations(CallbackInfo ci) {
        ContainerInventory inv = (ContainerInventory)this;
        for (int slot = 0; slot < inv.armorInventory.length; ++slot) {
            if (inv.armorInventory[slot] == null || inv.player.world == null) continue;
            inv.armorInventory[slot].updateAnimation(inv.player.world, (Entity)inv.player, slot + inv.mainInventory.length, inv.getCurrentItemIndex() == slot);
        }
    }

    @Inject(method={"removeItem(II)Lnet/minecraft/core/item/ItemStack;"}, at={@At(value="HEAD")})
    private void updateEffects(int index, int takeAmount, CallbackInfoReturnable<ItemStack> cir) {
        if (index < this.mainInventory.length) {
            return;
        }
        ItemStack itemStack = this.armorInventory[index - this.mainInventory.length];
        if (itemStack != null && itemStack.getItem() instanceof IAccessoryEffects) {
            ((IAccessoryEffects)itemStack.getItem()).removeEffect(this.player, itemStack);
        }
    }

    @Inject(method={"setItem(ILnet/minecraft/core/item/ItemStack;)V"}, at={@At(value="HEAD")})
    private void updateEffects(int index, ItemStack newItem, CallbackInfo ci) {
        if (index < this.mainInventory.length) {
            return;
        }
        ItemStack oldItem = this.armorInventory[index - this.mainInventory.length];
        if (oldItem != null && oldItem.getItem() instanceof IAccessoryEffects) {
            ((IAccessoryEffects)oldItem.getItem()).removeEffect(this.player, oldItem);
        }
    }
}

