/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.dimension.bump_to_overworld;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import teamport.aether.entity.AetherMobFallingToOverworld;
import teamport.aether.world.AetherDimension;
import turniplabs.halplibe.helper.EnvironmentHelper;

@Mixin(value={Entity.class}, remap=false)
public abstract class EntityBumpToOverworldMixin {
    @Shadow
    public @Nullable World world;
    @Shadow
    public double y;
    @Shadow
    public @Nullable Entity passenger;

    @Shadow
    public abstract void remove();

    @Shadow
    public abstract Entity ejectRider();

    @Shadow
    public abstract boolean isPassenger();

    @Shadow
    public abstract @Nullable Entity getPassenger();

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void fallToOverWorld(CallbackInfo ci) {
        if (this.world == null || EnvironmentHelper.isClientWorld()) {
            return;
        }
        Dimension dimension = this.world.dimension;
        if (dimension.id == AetherDimension.getAether().id && this.y < (double)(this.world.worldType.getMinY() - 10)) {
            Entity entity;
            if (this.getPassenger() != null) {
                if (this.getPassenger() instanceof Player) {
                    return;
                }
                this.ejectRider();
            }
            if ((entity = (Entity)this) instanceof AetherMobFallingToOverworld) {
                ((AetherMobFallingToOverworld)entity).onLeavingAether();
                if (!((AetherMobFallingToOverworld)entity).canFallToOverworld()) {
                    this.remove();
                    return;
                }
            }
            AetherDimension.addEntityToFallen(entity);
        }
    }
}

