/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.dimension.bump_to_overworld;

import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import teamport.aether.world.AetherDimension;
import turniplabs.halplibe.helper.EnvironmentHelper;

@Environment(value=EnvType.CLIENT)
@Mixin(value={World.class}, remap=false)
public abstract class SPWorldMixin {
    @Shadow
    public Dimension dimension;
    @Shadow
    public Random rand;
    @Unique
    private int cooldown = 20;

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void tick(CallbackInfo ci) {
        --this.cooldown;
        if (this.cooldown < 0 && this.dimension.id == Dimension.OVERWORLD.id) {
            this.cooldown = 10 + this.rand.nextInt(10);
            if (EnvironmentHelper.isSinglePlayer()) {
                AetherDimension.loadEntitiesNearPlayer((Player)Minecraft.getMinecraft().thePlayer, (World)this);
            }
        }
    }
}

