/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.models.skyroot;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.block.model.BlockModelHorizontalRotation;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import teamport.aether.blocks.dungeon.BlockLogicChestMimic;

@Environment(value=EnvType.CLIENT)
public class BlockModelPaintedSkyrootMimic<T extends BlockLogicChestMimic>
extends BlockModelHorizontalRotation<T> {
    private static final IconCoordinate[] TOP_TEXTURES = new IconCoordinate[16];
    private static final IconCoordinate[] SIDE_TEXTURES = new IconCoordinate[16];
    private static final IconCoordinate[] FRONT_TEXTURES = new IconCoordinate[16];

    public BlockModelPaintedSkyrootMimic(Block<T> block) {
        super(block);
    }

    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int meta = blockAccess.getBlockMetadata(x, y, z);
        int color = meta >> 4;
        Side facing = BlockLogicChest.getDirectionFromMeta((int)meta).getSide();
        if (side == Side.TOP || side == Side.BOTTOM) {
            return TOP_TEXTURES[color];
        }
        if (side == facing) {
            return FRONT_TEXTURES[color];
        }
        return side.isHorizontal() ? SIDE_TEXTURES[color] : TOP_TEXTURES[color];
    }

    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int metadata) {
        int color = metadata >> 4;
        if (side == Side.SOUTH) {
            return FRONT_TEXTURES[color];
        }
        return side.isHorizontal() ? SIDE_TEXTURES[color] : TOP_TEXTURES[color];
    }

    static {
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            BlockModelPaintedSkyrootMimic.TOP_TEXTURES[c.blockMeta] = TextureRegistry.getTexture((String)("aether:block/chest/skyroot/" + c.colorID + "/top"));
            BlockModelPaintedSkyrootMimic.SIDE_TEXTURES[c.blockMeta] = TextureRegistry.getTexture((String)("aether:block/chest/skyroot/" + c.colorID + "/side"));
            BlockModelPaintedSkyrootMimic.FRONT_TEXTURES[c.blockMeta] = TextureRegistry.getTexture((String)("aether:block/chest/skyroot/" + c.colorID + "/front"));
        }
    }
}

