/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.net;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.net.entity.EntityTracker;
import net.minecraft.core.net.entity.EntityTrackerEntry;
import net.minecraft.core.net.entity.ITrackedEntry;
import net.minecraft.core.net.entity.IVehicleEntry;
import net.minecraft.core.net.packet.PacketAddEntity;
import net.minecraft.core.world.World;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import teamport.aether.AetherMod;
import teamport.aether.entity.vehicle.parachute.EntityParachute;
import teamport.aether.entity.vehicle.parachute.EntityParachuteGold;

public class NetEntryParachute
implements IVehicleEntry<EntityParachute>,
ITrackedEntry<EntityParachute> {
    public Entity getEntity(World world, double x, double y, double z, int meta, boolean hasVelocity, double xd, double yd, double zd, Entity owner, @Nullable CompoundTag compoundTag) {
        EntityParachute parachute;
        Class parachuteClass = meta >>> 24 > 0 ? EntityParachuteGold.class : EntityParachute.class;
        try {
            parachute = (EntityParachute)parachuteClass.getConstructor(World.class).newInstance(world);
        }
        catch (Exception e) {
            AetherMod.LOGGER.error("Failed to spawn parachute cloud!");
            throw new RuntimeException(e);
        }
        parachute.moveTo(x, y, z, 0.0f, 0.0f);
        return parachute;
    }

    public PacketAddEntity getSpawnPacket(EntityTrackerEntry entityTrackerEntry, EntityParachute tracked) {
        PacketAddEntity packet = new PacketAddEntity((Entity)tracked);
        packet.metaData = (tracked instanceof EntityParachuteGold ? 1 : 0) << 24;
        return packet;
    }

    public @NonNull Class<? extends EntityParachute> getAppliedClass() {
        return EntityParachute.class;
    }

    public int getTrackingDistance() {
        return 192;
    }

    public int getPacketDelay() {
        return 1;
    }

    public boolean sendMotionUpdates() {
        return false;
    }

    public void onEntityTracked(EntityTracker entityTracker, EntityTrackerEntry entityTrackerEntry, EntityParachute object) {
    }
}

