/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.net.message;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.entity.player.Player;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.net.PlayerList;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import teamport.aether.world.feature.util.map.DungeonMap;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class AetherDungeonMapUpdateNetworkMessage
implements NetworkMessage {
    private UUID playerUUID;
    private @Nullable ListTag entriesReceived = null;

    public AetherDungeonMapUpdateNetworkMessage() {
    }

    public AetherDungeonMapUpdateNetworkMessage(UUID uuid) {
        this.playerUUID = uuid;
    }

    public void encodeToUniversalPacket(@NonNull UniversalPacket packet) {
        if (EnvironmentHelper.isServerEnvironment()) {
            PlayerList playerList = MinecraftServer.getInstance().playerList;
            Player player = playerList.playerEntities.stream().filter(p -> p.uuid.compareTo(this.playerUUID) == 0).findFirst().orElse(null);
            if (player == null) {
                packet.writeInt(0);
                return;
            }
            packet.writeInt(1);
            CompoundTag tag = new CompoundTag();
            tag.putList("aether.dungeons", DungeonMap.serializeListFor(player));
            packet.writeCompoundTag(tag);
            return;
        }
        if (EnvironmentHelper.isClientWorld()) {
            packet.writeString(Minecraft.getMinecraft().thePlayer.uuid.toString());
        }
    }

    public void decodeFromUniversalPacket(@NonNull UniversalPacket packet) {
        if (EnvironmentHelper.isServerEnvironment()) {
            this.playerUUID = UUID.fromString(packet.readString());
        } else {
            if (packet.readInt() == 0) {
                return;
            }
            CompoundTag tag = packet.readCompoundTag();
            this.entriesReceived = tag.getList("aether.dungeons");
        }
    }

    public void handle(NetworkMessage.NetworkContext context) {
        if (EnvironmentHelper.isServerEnvironment()) {
            if (context.player == null) {
                return;
            }
            NetworkHandler.sendToPlayer((Player)context.player, (NetworkMessage)new AetherDungeonMapUpdateNetworkMessage(context.player.uuid));
            return;
        }
        if (EnvironmentHelper.isClientWorld() && this.entriesReceived != null) {
            DungeonMap.updateListCache(this.entriesReceived);
        }
    }
}

