/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.dungeon.bronze.component;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.util.helper.Direction;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.helper.unboxed.IntPair;
import teamport.aether.world.feature.dungeon.bronze.component.BaseBronzeRoom;
import teamport.aether.world.feature.util.BlockPallet;
import teamport.aether.world.feature.util.WorldFeatureBlock;
import teamport.aether.world.feature.util.WorldFeatureComponent;
import teamport.aether.world.feature.util.WorldFeaturePoint;

public class DisplayRoom
extends BaseBronzeRoom {
    private static final BlockPallet DISPLAY = new BlockPallet();

    public DisplayRoom() {
        this.addDoor(Direction.NORTH, WorldFeaturePoint.wfp(4, 1, 0), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.EAST, WorldFeaturePoint.wfp(11, 1, 4), Direction.UP, 6, Direction.SOUTH, 4);
        this.addDoor(Direction.SOUTH, WorldFeaturePoint.wfp(4, 1, 11), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.WEST, WorldFeaturePoint.wfp(0, 1, 4), Direction.UP, 6, Direction.SOUTH, 4);
    }

    @Override
    public void makeRoom() {
        IntPair idMeta;
        WorldFeaturePoint[] points;
        int i;
        this.room.add(WorldFeatureComponent.drawHollowShell(this.random, ROOM_PALLET, Direction.SOUTH, this.width, Direction.UP, this.height, Direction.EAST, this.width, this.x, this.y, this.z, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(AetherBlocks.SLAB_CARVED_STONE.id(), 0, Direction.SOUTH, 4, Direction.EAST, 2, this.x + 5, this.y + 1, this.z + 4, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(AetherBlocks.SLAB_CARVED_STONE.id(), 0, Direction.SOUTH, 2, Direction.EAST, 4, this.x + 4, this.y + 1, this.z + 5, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(this.random, ROOM_PALLET, Direction.SOUTH, 2, Direction.EAST, 2, this.x + 5, this.y + 1, this.z + 5, false));
        this.decoration.add(WorldFeatureComponent.drawVolume(AetherBlocks.CARVED_STONE_LIGHT.id(), 0, Direction.SOUTH, 2, Direction.EAST, 2, Direction.UP, 2, this.x + 5, this.y + 4, this.z + 5, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(this.random, ROOM_PALLET, Direction.SOUTH, 2, Direction.EAST, 2, this.x + 1, this.y + 1, this.z + 1, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(this.random, ROOM_PALLET, Direction.SOUTH, 2, Direction.EAST, 2, this.x + 1, this.y + 1, this.z + 9, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(this.random, ROOM_PALLET, Direction.SOUTH, 2, Direction.EAST, 2, this.x + 9, this.y + 1, this.z + 1, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(this.random, ROOM_PALLET, Direction.SOUTH, 2, Direction.EAST, 2, this.x + 9, this.y + 1, this.z + 9, false));
        ArrayList<WorldFeaturePoint[]> pointList = new ArrayList<WorldFeaturePoint[]>();
        pointList.add(new WorldFeaturePoint[]{WorldFeaturePoint.wfp(this.x + 1, this.y + 2, this.z + 1), WorldFeaturePoint.wfp(this.x + 2, this.y + 2, this.z + 1), WorldFeaturePoint.wfp(this.x + 1, this.y + 2, this.z + 2)});
        pointList.add(new WorldFeaturePoint[]{WorldFeaturePoint.wfp(this.x + 9, this.y + 2, this.z + 1), WorldFeaturePoint.wfp(this.x + 10, this.y + 2, this.z + 1), WorldFeaturePoint.wfp(this.x + 10, this.y + 2, this.z + 2)});
        pointList.add(new WorldFeaturePoint[]{WorldFeaturePoint.wfp(this.x + 1, this.y + 2, this.z + 9), WorldFeaturePoint.wfp(this.x + 1, this.y + 2, this.z + 10), WorldFeaturePoint.wfp(this.x + 2, this.y + 2, this.z + 10)});
        pointList.add(new WorldFeaturePoint[]{WorldFeaturePoint.wfp(this.x + 9, this.y + 2, this.z + 10), WorldFeaturePoint.wfp(this.x + 10, this.y + 2, this.z + 10), WorldFeaturePoint.wfp(this.x + 10, this.y + 2, this.z + 9)});
        Collections.shuffle(pointList, this.random);
        for (i = 0; i < 2; ++i) {
            for (WorldFeaturePoint point : points = (WorldFeaturePoint[])pointList.get(i)) {
                idMeta = DISPLAY.getRandom(this.random);
                this.chest.add(WorldFeatureBlock.wfb(point.getX(), point.getY(), point.getZ(), idMeta.getFirst(), idMeta.getSecond(), true));
            }
        }
        for (i = 2; i < pointList.size(); ++i) {
            for (WorldFeaturePoint point : points = (WorldFeaturePoint[])pointList.get(i)) {
                idMeta = CHEST_OR_MIMIC.getRandom(this.random);
                this.chest.add(WorldFeatureBlock.wfb(point.getX(), point.getY(), point.getZ(), idMeta.getFirst(), idMeta.getSecond(), false));
            }
        }
    }

    static {
        DISPLAY.addEntry(AetherBlocks.ORE_AMBROSIUM_HOLYSTONE.id(), 10.0);
        DISPLAY.addEntry(AetherBlocks.ORE_ZANITE_HOLYSTONE.id(), 5.0);
        DISPLAY.addEntry(AetherBlocks.ORE_GRAVITITE_HOLYSTONE.id(), 1.0);
    }
}

