/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.dungeon.bronze.component;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.Direction;
import teamport.aether.world.AetherDimension;
import teamport.aether.world.feature.dungeon.bronze.WorldFeatureAetherBronzeDungeon;
import teamport.aether.world.feature.dungeon.bronze.component.BaseBronzeRoom;
import teamport.aether.world.feature.util.WorldFeatureComponent;
import teamport.aether.world.feature.util.WorldFeaturePoint;

public class HallwayRoom
extends BaseBronzeRoom {
    public HallwayRoom() {
        this.roomWeight = 0.25f;
        this.liquidTolerance = 0.85f;
        this.airTolerance = 0.85f;
        this.bottomLiquidTolerance = 0.85f;
        this.topLiquidTolerance = 0.85f;
        this.bottomAirTolerance = 0.85f;
        this.topAirTolerance = 0.85f;
        this.addDoor(Direction.NORTH, WorldFeaturePoint.wfp(4, 1, 0), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.EAST, WorldFeaturePoint.wfp(11, 1, 4), Direction.UP, 6, Direction.SOUTH, 4);
        this.addDoor(Direction.SOUTH, WorldFeaturePoint.wfp(4, 1, 11), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.WEST, WorldFeaturePoint.wfp(0, 1, 4), Direction.UP, 6, Direction.SOUTH, 4);
    }

    @Override
    public boolean canPlace() {
        if (this.y <= 11 && this.y + this.height + 3 >= this.world.getHeightBlocks()) {
            return false;
        }
        int countAir = 0;
        int countLiquid = 0;
        WorldFeatureComponent check = WorldFeatureComponent.drawVolume(0, 0, Direction.SOUTH, this.width, Direction.UP, 7, Direction.EAST, 4, this.x + 4, this.y, this.z, false);
        check.add(WorldFeatureComponent.drawVolume(0, 0, Direction.SOUTH, 4, Direction.UP, 7, Direction.EAST, this.length, this.x, this.y, this.z + 4, false));
        for (WorldFeaturePoint worldFeaturePoint : check.getBlockList()) {
            Material blockMaterial;
            Block block = this.world.getBlock(worldFeaturePoint.getX(), worldFeaturePoint.getY(), worldFeaturePoint.getZ());
            Material material = blockMaterial = block == null ? Material.air : block.getMaterial();
            if (block != null && block.blockHardness < 0.0f) {
                return false;
            }
            if (blockMaterial == Material.air) {
                ++countAir;
            }
            if (!blockMaterial.isLiquid()) continue;
            ++countLiquid;
        }
        return (float)check.getBlockList().size() * this.airTolerance >= (float)countAir && (float)check.getBlockList().size() * this.liquidTolerance >= (float)countLiquid;
    }

    @Override
    public void makeRoom() {
        if (this.world.dimension.equals(AetherDimension.getAether())) {
            this.room.add(WorldFeatureComponent.drawVolume(this.random, WorldFeatureAetherBronzeDungeon.holystone, Direction.SOUTH, 6, Direction.UP, 8, Direction.EAST, 6, this.x + 3, this.y, this.z + 3, false));
        }
        this.room.add(WorldFeatureComponent.drawVolume(0, 0, Direction.SOUTH, 4, Direction.UP, 6, Direction.EAST, 4, this.x + 4, this.y + 1, this.z + 4, false));
    }

    @Override
    public void markDoor(BaseBronzeRoom.Door door, BaseBronzeRoom.ClosingType closingType) {
        super.markDoor(door, closingType);
        if (closingType != BaseBronzeRoom.ClosingType.PLACED) {
            return;
        }
        WorldFeaturePoint p2 = WorldFeaturePoint.wfp().moveInDirection(door.getHeading().getOpposite()).multiply(7).add(door.getP2());
        if (this.world.dimension.equals(AetherDimension.getAether())) {
            WorldFeaturePoint liningBottomCorner = door.getP1().copy();
            WorldFeaturePoint liningTopCorner = p2.copy();
            WorldFeatureAetherBronzeDungeon.adjustCornerForLining(door.getHeading(), liningBottomCorner, liningTopCorner);
            WorldFeatureAetherBronzeDungeon.placeWorldLining(this.world, WorldFeatureComponent.drawVolumeWithPoint(this.random, WorldFeatureAetherBronzeDungeon.holystone, liningBottomCorner, liningTopCorner, false));
        }
        this.room.add(WorldFeatureComponent.drawVolume(0, 0, door.getP1(), p2, false));
        this.placeRoom();
    }
}

