/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.util;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.IntTag;
import com.mojang.nbt.tags.Tag;
import java.util.Objects;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;

public class WorldFeaturePoint {
    private int x;
    private int y;
    private int z;

    public WorldFeaturePoint() {
        this.z = 0;
        this.y = 0;
        this.x = 0;
    }

    public WorldFeaturePoint(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public WorldFeaturePoint(int length) {
        this.x = length;
        this.y = length;
        this.z = length;
    }

    public static WorldFeaturePoint wfp() {
        return new WorldFeaturePoint(0, 0, 0);
    }

    public static WorldFeaturePoint wfp(int x, int y, int z) {
        return new WorldFeaturePoint(x, y, z);
    }

    public static WorldFeaturePoint wfpoint(Entity e) {
        return new WorldFeaturePoint((int)e.x, (int)e.y, (int)e.z);
    }

    public void set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public String toString() {
        return String.format("(x:%d y:%d z:%d)", this.x, this.y, this.z);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof WorldFeaturePoint)) {
            return false;
        }
        WorldFeaturePoint mem = (WorldFeaturePoint)o;
        return mem.x == this.x && mem.y == this.y && mem.z == this.z;
    }

    public CompoundTag toCompoundTag() {
        CompoundTag result = new CompoundTag();
        result.put("x", (Tag)new IntTag(this.x));
        result.put("y", (Tag)new IntTag(this.y));
        result.put("z", (Tag)new IntTag(this.z));
        return result;
    }

    public static WorldFeaturePoint fromCompoundTag(CompoundTag tag) {
        return new WorldFeaturePoint(tag.getInteger("x"), tag.getInteger("y"), tag.getInteger("z"));
    }

    public WorldFeaturePoint copy() {
        return new WorldFeaturePoint(this.x, this.y, this.z);
    }

    public WorldFeaturePoint add(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public WorldFeaturePoint add(WorldFeaturePoint point) {
        this.x += point.x;
        this.y += point.y;
        this.z += point.z;
        return this;
    }

    public WorldFeaturePoint subtract(int x, int y, int z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public WorldFeaturePoint subtract(WorldFeaturePoint point) {
        this.x -= point.x;
        this.y -= point.y;
        this.z -= point.z;
        return this;
    }

    public WorldFeaturePoint multiply(int scala) {
        this.x *= scala;
        this.y *= scala;
        this.z *= scala;
        return this;
    }

    public WorldFeaturePoint moveInDirection(Direction direction) {
        Side side = direction.getSide();
        this.x += side.getOffsetX();
        this.y += side.getOffsetY();
        this.z += side.getOffsetZ();
        return this;
    }

    public WorldFeaturePoint moveInDirection(Direction direction, int amount) {
        Side side = direction.getSide();
        this.x += side.getOffsetX() * amount;
        this.y += side.getOffsetY() * amount;
        this.z += side.getOffsetZ() * amount;
        return this;
    }

    public double distanceTo(WorldFeaturePoint point) {
        double dx = (double)this.x - (double)point.x;
        double dy = (double)this.y - (double)point.y;
        double dz = (double)this.z - (double)point.z;
        return MathHelper.sqrt((double)(dx * dx + dy * dy + dz * dz));
    }

    public double distanceTo(int x, int y, int z) {
        double dx = (double)this.x - (double)x;
        double dy = (double)this.y - (double)y;
        double dz = (double)this.z - (double)z;
        return MathHelper.sqrt((double)(dx * dx + dy * dy + dz * dz));
    }

    public WorldFeaturePoint rotateY(float radian) {
        float cos = MathHelper.cos((float)radian);
        float sin = MathHelper.sin((float)radian);
        int theX = (int)Math.round((double)this.x * (double)cos - (double)this.z * (double)sin);
        int theZ = (int)Math.round((double)this.x * (double)sin + (double)this.z * (double)cos);
        this.x = theX;
        this.z = theZ;
        return this;
    }

    public WorldFeaturePoint rotateYAroundPivot(int pivotX, int pivotY, int pivotZ, float angle) {
        return this.subtract(pivotX, pivotY, pivotZ).rotateY(MathHelper.toRadians((float)angle)).add(pivotX, pivotY, pivotZ);
    }

    public WorldFeaturePoint rotateYAroundPivot(WorldFeaturePoint pivotPoint, Direction direction) {
        switch (direction) {
            case EAST: {
                this.subtract(pivotPoint);
                this.set(-this.z, this.y, this.x);
                this.add(pivotPoint);
                break;
            }
            case SOUTH: {
                this.subtract(pivotPoint);
                this.set(-this.x, this.y, -this.z);
                this.add(pivotPoint);
                break;
            }
            case WEST: {
                this.subtract(pivotPoint);
                this.set(this.z, this.y, -this.x);
                this.add(pivotPoint);
                break;
            }
        }
        return this;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }
}

