/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc;

import fiveavian.proxvc.api.ServerEvents;
import fiveavian.proxvc.vc.server.VCRelayServer;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.minecraft.server.MinecraftServer;

public class ProxVCServer
implements DedicatedServerModInitializer {
    public MinecraftServer server;
    public DatagramSocket socket;
    public Thread relayThread;

    public void onInitializeServer() {
        ServerEvents.START.add(this::start);
        ServerEvents.STOP.add(this::stop);
    }

    private void start(MinecraftServer server) {
        this.server = server;
        try {
            String ip = server.propertyManager.getStringProperty("server-ip", "");
            int port = server.propertyManager.getIntProperty("server-port", 25565);
            this.socket = new DatagramSocket(port, ip.isEmpty() ? null : InetAddress.getByName(ip));
            this.relayThread = new Thread(new VCRelayServer(this));
            this.relayThread.start();
        }
        catch (SocketException | UnknownHostException ex) {
            System.out.println("Failed to start the ProxVC server because of an exception.");
            System.out.println("Continuing without ProxVC.");
            ex.printStackTrace();
        }
    }

    private void stop(MinecraftServer server) {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            if (this.relayThread != null) {
                this.relayThread.join();
            }
        }
        catch (InterruptedException ex) {
            System.out.println("Failed to stop the ProxVC server because of an exception.");
            ex.printStackTrace();
        }
    }
}

