/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc.gui;

import fiveavian.proxvc.util.MixerStore;
import fiveavian.proxvc.vc.StreamingAudioSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.GuiElement;
import net.minecraft.client.gui.ListLayout;
import net.minecraft.client.gui.SliderElement;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Listener;

public class VolumeMixerComponent
implements OptionsComponent,
Listener<ButtonElement> {
    private final float AMP_FACTOR = 10.0f;
    private static final int BUTTON_HEIGHT = 20;
    private final Minecraft mc = Minecraft.getMinecraft();
    private final Map<Integer, StreamingAudioSource> sources;
    private final ListLayout slidersLayout;
    private final Map<Integer, SliderElement> entityIdToSlider = new HashMap<Integer, SliderElement>();
    private final Map<Integer, String> entityIdToName = new HashMap<Integer, String>();
    private final Map<SliderElement, ButtonElement> sliderToResetButton = new HashMap<SliderElement, ButtonElement>();
    private int absoluteMouseX = 0;
    private int absoluteMouseY = 0;
    private int relativeMouseX = 0;
    private int relativeMouseY = 0;
    private boolean renderTooltip = false;
    private final TooltipElement tooltipElement = new TooltipElement(this.mc);

    public VolumeMixerComponent(Map<Integer, StreamingAudioSource> sources) {
        this.sources = sources;
        this.slidersLayout = new ListLayout(this.mc.currentScreen).setAlign(0.0, 0.0).setVertical(true).setElementSize(150, 20).setMargin(1);
        MixerStore.load();
    }

    public int getHeight() {
        if (this.renderTooltip) {
            return 85 + this.relativeMouseY;
        }
        if (this.sources.isEmpty()) {
            return 10;
        }
        return this.slidersLayout.elements.size() * 20 + (this.slidersLayout.elements.size() - 1) * this.slidersLayout.margin;
    }

    public void render(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        this.absoluteMouseX = x + relativeMouseX;
        this.absoluteMouseY = y + relativeMouseY;
        this.relativeMouseX = relativeMouseX;
        this.relativeMouseY = relativeMouseY;
        if (this.sources.isEmpty() && this.mc.currentWorld != null && relativeMouseY > 0 && relativeMouseY < 10 && relativeMouseX > 0) {
            this.tooltipElement.zLevel = 2.0f;
            this.tooltipElement.render("\u00a7cIf you think this shouldn't be \n\u00a7chappening check the following\n\n\u2022 There are players with the mod in render distance.\n\u2022 The ProxVC mod is installed on the server.\n\n\u00a77If you are still having issues, \n\u00a77please report it on the ProxVC GitHub page.", this.absoluteMouseX, this.absoluteMouseY, 8, 8);
            this.renderTooltip = true;
        } else {
            this.renderTooltip = false;
        }
        if (this.mc.currentWorld == null) {
            this.mc.currentScreen.drawString(this.mc.font, "Load into a server first!", x + 5, y, 0xFFFFFF);
            return;
        }
        if (this.sources.isEmpty()) {
            this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/sprites/screen/creative/clear.png").bind();
            Tessellator.instance.startDrawingQuads();
            Tessellator.instance.setColorRGBA_F(1.0f, 1.0f, 1.0f, 0.5f);
            Tessellator.instance.drawRectangleWithUV(x - 10, y, 9, 9, 1.0, 0.0, 1.0, 1.0);
            Tessellator.instance.draw();
            this.mc.currentScreen.drawString(this.mc.font, (this.renderTooltip ? TextFormatting.YELLOW.toString() : "") + "No audio sources found.", x + 5, y, 0xFFFFFF);
            return;
        }
        this.slidersLayout.setOffset(x, y);
        this.slidersLayout.updateElementPositions();
        for (GuiElement element : this.slidersLayout.elements) {
            SliderElement slider = (SliderElement)element;
            slider.drawButton(this.mc, x + relativeMouseX, y + relativeMouseY);
            ButtonElement resetButton = this.sliderToResetButton.get(slider);
            resetButton.xPosition = x + slider.width + 3;
            resetButton.yPosition = slider.yPosition;
            resetButton.drawButton(this.mc, this.absoluteMouseX, this.absoluteMouseY);
        }
    }

    public void onMouseClick(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        for (GuiElement element : this.slidersLayout.elements) {
            ButtonElement resetButton;
            SliderElement slider = (SliderElement)element;
            if (slider.mouseClicked(this.mc, this.absoluteMouseX, this.absoluteMouseY)) {
                this.listen((ButtonElement)slider);
                this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
            }
            if (!(resetButton = this.sliderToResetButton.get(slider)).mouseClicked(this.mc, this.absoluteMouseX, this.absoluteMouseY)) continue;
            slider.sliderValue = 0.1f;
            this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
            this.listen((ButtonElement)slider);
        }
    }

    public void onMouseMove(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        for (GuiElement element : this.slidersLayout.elements) {
            SliderElement slider = (SliderElement)element;
            slider.mouseDragged(this.mc, this.absoluteMouseX, this.absoluteMouseY);
            if (!slider.dragging) continue;
            this.listen((ButtonElement)slider);
        }
    }

    public void onMouseRelease(int i, int j, int k, int l, int m, int n) {
        for (GuiElement element : this.slidersLayout.elements) {
            SliderElement slider = (SliderElement)element;
            slider.mouseReleased(this.absoluteMouseX, this.absoluteMouseY);
        }
    }

    public void tick() {
        this.updateSources();
    }

    public boolean matchesSearchTerm(String string) {
        return false;
    }

    public void init(Minecraft mc) {
        this.updateSources();
    }

    void updateSources() {
        for (GuiElement guiElement : new ArrayList(this.slidersLayout.elements)) {
            SliderElement slider = (SliderElement)guiElement;
            if (this.sources.containsKey(slider.id)) continue;
            this.slidersLayout.elements.remove(guiElement);
            this.entityIdToSlider.remove(slider.id);
            this.entityIdToName.remove(slider.id);
            this.sliderToResetButton.remove(slider);
        }
        for (Map.Entry entry : new HashMap<Integer, StreamingAudioSource>(this.sources).entrySet()) {
            int entityId = (Integer)entry.getKey();
            StreamingAudioSource source = (StreamingAudioSource)entry.getValue();
            if (this.entityIdToSlider.containsKey(entityId)) continue;
            String entityName = null;
            for (Entity player : this.mc.currentWorld.loadedEntityList) {
                if (player.id != entityId) continue;
                entityName = ((Player)player).username;
                break;
            }
            assert (entityName != null);
            SliderElement slider = new SliderElement(entityId, 0, 0, 150, 20, "", source.volume / 10.0f);
            this.updateSliderDisplayString(slider, entityName);
            slider.enabled = true;
            ButtonElement resetButton = new ButtonElement(0, 0, 0, 20, 20, "").setTextures("minecraft:gui/misc/icon_reset", "minecraft:gui/misc/icon_reset_highlighted", "minecraft:gui/misc/icon_reset");
            this.entityIdToSlider.put(entityId, slider);
            this.slidersLayout.addElement((GuiElement)slider);
            this.entityIdToName.put(entityId, entityName);
            this.sliderToResetButton.put(slider, resetButton);
        }
    }

    public void listen(ButtonElement object) {
        SliderElement slider = (SliderElement)object;
        StreamingAudioSource source = this.sources.get(slider.id);
        if (source != null) {
            String entityName = this.entityIdToName.get(slider.id);
            this.updateSliderDisplayString(slider, entityName);
            source.volume = (float)(slider.sliderValue * 10.0);
            MixerStore.setMixerProperty(slider.id, (float)(slider.sliderValue * 10.0));
        } else {
            this.slidersLayout.elements.remove(object);
            this.entityIdToSlider.remove(slider.id);
            this.entityIdToName.remove(slider.id);
            this.sliderToResetButton.remove(slider);
        }
    }

    public void updateSliderDisplayString(SliderElement slider, String entityName) {
        slider.displayString = "Volume: " + (entityName.length() > 8 ? entityName.substring(0, 7) + "..." : entityName) + " (" + (int)(slider.sliderValue * 10.0 * 100.0) + "%)";
    }

    public void onClose() {
    }

    public void onKeyPress(int i, char c) {
    }
}

