/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc.mixin.client;

import fiveavian.proxvc.api.ClientEvents;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.net.handler.PacketHandlerClient;
import net.minecraft.core.net.packet.PacketDisconnect;
import net.minecraft.core.net.packet.PacketLogin;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PacketHandlerClient.class}, remap=false)
public class PacketHandlerClientMixin {
    @Shadow
    @Final
    private Minecraft mc;
    @Shadow
    private boolean disconnected;

    @Inject(method={"handleLogin"}, at={@At(value="TAIL")})
    public void handleLogin(PacketLogin packet, CallbackInfo ci) {
        for (BiConsumer<Minecraft, PacketLogin> listener : ClientEvents.LOGIN) {
            listener.accept(this.mc, packet);
        }
    }

    @Inject(method={"sendFinalPacket"}, at={@At(value="HEAD")})
    public void sendFinalPacket(CallbackInfo ci) {
        for (Consumer<Minecraft> listener : ClientEvents.DISCONNECT) {
            listener.accept(this.mc);
        }
    }

    @Inject(method={"handleKickDisconnect"}, at={@At(value="HEAD")})
    public void handleKickDisconnect(PacketDisconnect packet, CallbackInfo ci) {
        for (Consumer<Minecraft> listener : ClientEvents.DISCONNECT) {
            listener.accept(this.mc);
        }
    }

    @Inject(method={"handleErrorMessage"}, at={@At(value="HEAD")})
    public void handleErrorMessage(String s, Object[] errorLines, CallbackInfo ci) {
        if (!this.disconnected) {
            for (Consumer<Minecraft> listener : ClientEvents.DISCONNECT) {
                listener.accept(this.mc);
            }
        }
    }
}

