/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc.util;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public class DatagramPacketWrapper {
    private final DatagramSocket socket;
    public final byte[] array;
    public final ByteBuffer buffer;
    public final DatagramPacket packet;

    public DatagramPacketWrapper(DatagramSocket socket, int maxSize) {
        this.socket = socket;
        this.array = new byte[maxSize];
        this.buffer = ByteBuffer.wrap(this.array);
        this.packet = new DatagramPacket(this.array, maxSize);
    }

    public void receive() throws IOException {
        this.packet.setLength(this.array.length);
        this.socket.receive(this.packet);
        this.buffer.rewind();
    }

    public void send(SocketAddress address) throws IOException {
        this.packet.setSocketAddress(address);
        this.packet.setLength(this.buffer.position());
        this.socket.send(this.packet);
        this.buffer.rewind();
    }
}

