/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc.util;

import fiveavian.proxvc.ProxVCClient;
import java.nio.ByteBuffer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class Waveforms {
    private static final int[] blankPoints = new int[20];

    public static int[] getWaveformPoints(ByteBuffer samples, int numPoints) {
        if (samples == null) {
            return blankPoints;
        }
        int sampleCount = samples.remaining() / 2;
        int[] points = new int[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            int sampleIndex = i * sampleCount / numPoints;
            short sample = samples.getShort(sampleIndex * 2);
            points[i] = sample;
        }
        return points;
    }

    public static void renderWaveformStyle(types type, int[] points, float x, float y, float width, float height, float alpha, boolean drawBackground, Float distanceFromCamera) {
        if (points == null) {
            points = blankPoints;
        }
        if (type == null) {
            type = (types)((Object)ProxVCClient.instance.waveformType.value);
        }
        switch (type) {
            case OFF: {
                return;
            }
            case PARTICLE: {
                Waveforms.renderParticleWaveform(points, x, y, width, height, alpha);
                break;
            }
            case GLOW: {
                if (drawBackground) {
                    Waveforms.drawBackground(x, y, width, height, alpha * alpha);
                }
                Waveforms.renderGlowWaveform(points, x, y, width, height, alpha);
                break;
            }
            case DOT: {
                if (drawBackground) {
                    Waveforms.drawBackground(x, y, width, height, alpha);
                }
                Waveforms.renderDotWaveform(points, x, y, width, height, alpha);
                break;
            }
            case SPECTRUM: {
                if (drawBackground) {
                    Waveforms.drawBackground(x, y, width, height, alpha);
                }
                Waveforms.renderSpectrumWaveform(points, x, y, width, height, alpha);
                break;
            }
            case RING: {
                Waveforms.renderRingWaveform(points, x, y, width, height, alpha);
                break;
            }
            default: {
                if (drawBackground) {
                    Waveforms.drawBackground(x, y, width, height, alpha);
                }
                Waveforms.renderWaveform(points, x, y, width, height, alpha);
            }
        }
    }

    private static void drawBackground(float x, float y, float width, float height, float alpha) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
        tessellator.addVertex((double)(x - 1.0f), (double)(y - 1.0f), 0.0);
        tessellator.addVertex((double)(x - 1.0f), (double)(y + height + 1.0f), 0.0);
        tessellator.addVertex((double)(x + width + 1.0f), (double)(y + height + 1.0f), 0.0);
        tessellator.addVertex((double)(x + width + 1.0f), (double)(y - 1.0f), 0.0);
        tessellator.draw();
    }

    private static void renderRingWaveform(int[] points, float x, float y, float width, float height, float alpha) {
        int n = points.length;
        float centerX = x + width / 2.0f;
        float centerY = y + height / 2.0f;
        float maxRadius = Math.min(width, height) / 3.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        for (int i = 0; i < n; i += 2) {
            float amplitude = (float)Math.abs(points[i]) / 32768.0f;
            float radius = maxRadius * ((float)i / (float)n + amplitude * 0.3f);
            GL11.glBegin((int)2);
            GL11.glColor4f((float)(0.3f + amplitude * 0.7f), (float)0.5f, (float)1.0f, (float)(alpha * (1.0f - (float)i / (float)n)));
            for (int j = 0; j < 32; ++j) {
                float angle = (float)((double)j * Math.PI * 2.0 / 32.0);
                float distortion = amplitude * (float)Math.sin(angle * 3.0f + (float)System.currentTimeMillis() / 200.0f) * radius * 0.2f;
                float px = centerX + (float)Math.cos(angle) * (radius + distortion);
                float py = centerY + (float)Math.sin(angle) * (radius + distortion);
                GL11.glVertex2f((float)px, (float)py);
            }
            GL11.glEnd();
        }
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3553);
    }

    private static void renderSpectrumWaveform(int[] points, float x, float y, float width, float height, float alpha) {
        int n = points.length;
        float barWidth = width / (float)n - 1.0f;
        GL11.glDisable((int)3553);
        for (int i = 0; i < n; ++i) {
            float px = x + (float)i * (barWidth + 1.0f);
            float amplitude = (float)Math.abs(points[i]) / 32768.0f;
            for (int seg = 0; seg < 5; ++seg) {
                float segHeight = height / 5.0f;
                float segY = y + height - (float)seg * segHeight;
                float segAmplitude = amplitude * 5.0f - (float)seg;
                if (!(segAmplitude > 0.0f)) continue;
                switch (seg) {
                    case 4: {
                        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)alpha);
                        break;
                    }
                    case 3: {
                        GL11.glColor4f((float)1.0f, (float)0.5f, (float)0.0f, (float)alpha);
                        break;
                    }
                    case 2: {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)alpha);
                        break;
                    }
                    case 1: {
                        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)alpha);
                        break;
                    }
                    case 0: {
                        GL11.glColor4f((float)0.0f, (float)1.0f, (float)1.0f, (float)alpha);
                    }
                }
                GL11.glBegin((int)7);
                GL11.glVertex2f((float)px, (float)segY);
                GL11.glVertex2f((float)(px + barWidth), (float)segY);
                GL11.glVertex2f((float)(px + barWidth), (float)(segY - segHeight * Math.min(1.0f, segAmplitude)));
                GL11.glVertex2f((float)px, (float)(segY - segHeight * Math.min(1.0f, segAmplitude)));
                GL11.glEnd();
            }
        }
        GL11.glEnable((int)3553);
    }

    private static void renderWaveform(int[] points, float x, float y, float width, float height, float alpha) {
        int n = points.length;
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)2.0f);
        GL11.glBegin((int)3);
        for (int i = 0; i < n; ++i) {
            float norm;
            float px = x + (float)i * width / (float)(n - 1);
            float r = norm = (float)Math.abs(points[i]) / 32768.0f;
            float g = 1.0f - norm;
            GL11.glColor4f((float)r, (float)g, (float)0.0f, (float)alpha);
            float py = y + height / 2.0f - (float)points[i] / 32768.0f * (height / 2.0f);
            GL11.glVertex2f((float)px, (float)py);
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    private static void renderParticleWaveform(int[] points, float x, float y, float width, float height, float alpha) {
        int n = points.length;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2832);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        for (int i = 0; i < n; ++i) {
            float amplitude = (float)Math.abs(points[i]) / 32768.0f;
            float angle = (float)((double)i * Math.PI * 2.0 / (double)n);
            for (int p = 0; p < 5; ++p) {
                float spread = (float)(Math.random() * (double)amplitude * (double)height * 0.3);
                float px = x + width / 2.0f + (float)Math.cos(angle) * (width / 2.0f * amplitude + spread);
                float py = y + height / 2.0f + (float)Math.sin(angle) * (height / 2.0f * amplitude + spread);
                GL11.glPointSize((float)(1.0f + amplitude * 5.0f));
                GL11.glBegin((int)0);
                GL11.glColor4f((float)(0.5f + amplitude * 1.0f), (float)(0.8f - amplitude * 1.0f), (float)(1.0f - amplitude * 1.0f), (float)(alpha * (1.0f - (float)p / 5.0f)));
                GL11.glVertex2f((float)px, (float)py);
                GL11.glEnd();
            }
        }
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
        GL11.glEnable((int)3553);
    }

    private static void renderGlowWaveform(int[] points, float x, float y, float width, float height, float alpha) {
        int n = points.length;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        for (int layer = 0; layer < 3; ++layer) {
            float layerAlpha = MathHelper.lerp((float)1.0f, (float)0.3f, (float)((float)layer * 0.3f)) * alpha;
            float layerWidth = MathHelper.lerp((float)2.0f, (float)7.0f, (float)((float)layer * 0.3f));
            GL11.glLineWidth((float)layerWidth);
            GL11.glBegin((int)3);
            for (int i = 0; i < n; ++i) {
                float px = x + (float)i * width / (float)(n - 1);
                float py = y + height / 2.0f - (float)points[i] / 32768.0f * (height / 2.0f);
                GL11.glColor4f((float)0.3f, (float)0.7f, (float)1.0f, (float)layerAlpha);
                GL11.glVertex2f((float)px, (float)py);
            }
            GL11.glEnd();
        }
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3553);
    }

    private static void renderOscilloscopeWaveform(int[] points, float x, float y, float width, float height, float alpha) {
        int i;
        int n = points.length;
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)1.0f);
        GL11.glColor4f((float)0.2f, (float)0.2f, (float)0.2f, (float)(alpha * 0.5f));
        for (i = 0; i <= 10; ++i) {
            float gx = x + width * (float)i / 10.0f;
            GL11.glBegin((int)1);
            GL11.glVertex2f((float)gx, (float)y);
            GL11.glVertex2f((float)gx, (float)(y + height));
            GL11.glEnd();
        }
        for (i = 0; i <= 4; ++i) {
            float gy = y + height * (float)i / 4.0f;
            GL11.glBegin((int)1);
            GL11.glVertex2f((float)x, (float)gy);
            GL11.glVertex2f((float)(x + width), (float)gy);
            GL11.glEnd();
        }
        GL11.glLineWidth((float)2.0f);
        GL11.glBegin((int)3);
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)alpha);
        for (i = 0; i < n; ++i) {
            float px = x + (float)i * width / (float)(n - 1);
            float amplitude = (float)points[i] / 32768.0f;
            float py = y + height / 2.0f + amplitude * height / 2.0f;
            GL11.glVertex2f((float)px, (float)py);
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    private static void renderDotWaveform(int[] points, float x, float y, float width, float height, float alpha) {
        int n = points.length;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2832);
        GL11.glPointSize((float)3.0f);
        GL11.glBegin((int)0);
        for (int i = 0; i < n; ++i) {
            float px = x + (float)i * width / (float)(n - 1);
            float amplitude = (float)Math.abs(points[i]) / 32768.0f;
            float py = y + height / 2.0f - amplitude * (height / 2.0f);
            GL11.glColor4f((float)amplitude, (float)(0.2f + 0.8f * (1.0f - amplitude)), (float)1.0f, (float)alpha);
            GL11.glVertex2f((float)px, (float)py);
        }
        GL11.glEnd();
        GL11.glDisable((int)2832);
        GL11.glEnable((int)3553);
    }

    public static enum types {
        OFF,
        BASIC,
        PARTICLE,
        GLOW,
        DOT,
        SPECTRUM,
        RING;

    }
}

