/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc.vc;

import fiveavian.proxvc.vc.EFXConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.EXTEfx;

public class EFX
implements AutoCloseable {
    private final int source;
    public Integer reverbSlot;
    public Integer reverbEffect;
    public boolean reverbEnabled = true;
    public Integer lowpassFilter = null;
    public float lowpassIntensity = 0.5f;
    private static final List<Vec3> directions = Collections.unmodifiableList(Arrays.asList(Vec3.getPermanentVec3((double)1.0, (double)0.0, (double)0.0), Vec3.getPermanentVec3((double)-1.0, (double)0.0, (double)0.0), Vec3.getPermanentVec3((double)0.0, (double)1.0, (double)0.0), Vec3.getPermanentVec3((double)0.0, (double)-1.0, (double)0.0), Vec3.getPermanentVec3((double)0.0, (double)0.0, (double)1.0), Vec3.getPermanentVec3((double)0.0, (double)0.0, (double)-1.0), Vec3.getPermanentVec3((double)1.0, (double)1.0, (double)0.0).normalize(), Vec3.getPermanentVec3((double)1.0, (double)-1.0, (double)0.0).normalize(), Vec3.getPermanentVec3((double)-1.0, (double)1.0, (double)0.0).normalize(), Vec3.getPermanentVec3((double)-1.0, (double)-1.0, (double)0.0).normalize(), Vec3.getPermanentVec3((double)1.0, (double)0.0, (double)1.0).normalize(), Vec3.getPermanentVec3((double)1.0, (double)0.0, (double)-1.0).normalize(), Vec3.getPermanentVec3((double)-1.0, (double)0.0, (double)1.0).normalize(), Vec3.getPermanentVec3((double)-1.0, (double)0.0, (double)-1.0).normalize(), Vec3.getPermanentVec3((double)0.0, (double)1.0, (double)1.0).normalize(), Vec3.getPermanentVec3((double)0.0, (double)1.0, (double)-1.0).normalize(), Vec3.getPermanentVec3((double)0.0, (double)-1.0, (double)1.0).normalize(), Vec3.getPermanentVec3((double)0.0, (double)-1.0, (double)-1.0).normalize()));

    public EFX(int source) {
        this.source = source;
        this.setupLowpass();
        this.setupReverb();
    }

    public void setupLowpass() {
        int filter = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)filter, (int)32769, (int)1);
        EXTEfx.alFilterf((int)filter, (int)1, (float)1.0f);
        EXTEfx.alFilterf((int)filter, (int)2, (float)this.lowpassIntensity);
        AL10.alSourcei((int)this.source, (int)131077, (int)filter);
        this.lowpassFilter = filter;
    }

    public void setLowpassIntensity(float intensity, float partialTick) {
        if (this.lowpassFilter == null) {
            return;
        }
        if (Math.abs((intensity = MathHelper.clamp((float)intensity, (float)0.0f, (float)EFXConfig.NOEFFECT_LOWPASS)) - this.lowpassIntensity) < 0.01f) {
            return;
        }
        float speed = 0.15f;
        if (intensity > this.lowpassIntensity) {
            speed = 0.01f;
        }
        this.lowpassIntensity = MathHelper.lerp((float)this.lowpassIntensity, (float)intensity, (float)(speed * partialTick * 20.0f));
        this.lowpassIntensity = MathHelper.clamp((float)this.lowpassIntensity, (float)0.0f, (float)1.0f);
        EXTEfx.alFilterf((int)this.lowpassFilter, (int)2, (float)this.lowpassIntensity);
        EXTEfx.alEffectf((int)this.lowpassFilter, (int)1, (float)0.03f);
        AL10.alSourcei((int)this.source, (int)131077, (int)this.lowpassFilter);
    }

    public void setupReverb() {
        int slot = EXTEfx.alGenAuxiliaryEffectSlots();
        int effect = EXTEfx.alGenEffects();
        EXTEfx.alEffecti((int)effect, (int)32769, (int)32768);
        EXTEfx.alAuxiliaryEffectSloti((int)slot, (int)1, (int)effect);
        EXTEfx.alEffectf((int)effect, (int)3, (float)0.0f);
        this.reverbSlot = slot;
        this.reverbEffect = effect;
        this.reverbEnabled = true;
        AL11.alSource3i((int)this.source, (int)131078, (int)this.reverbEffect, (int)0, (int)131077);
    }

    public void calculateMuffleIntensity(Minecraft client, Player entity, float intensityOptionFloatValue) {
        boolean isInRoomFromEars;
        if (intensityOptionFloatValue == 0.0f) {
            this.setLowpassIntensity(EFXConfig.NOEFFECT_LOWPASS, client.timer.partialTicks);
            return;
        }
        HitResult hitFromEars = client.currentWorld.checkBlockCollisionBetweenPoints(client.thePlayer.getPosition(0.0f, true), entity.getPosition(0.0f, true), false);
        HitResult hitFromSource = client.currentWorld.checkBlockCollisionBetweenPoints(entity.getPosition(0.0f, true), client.thePlayer.getPosition(0.0f, true), false);
        if (hitFromEars == null || hitFromSource == null || hitFromEars.hitType != HitResult.HitType.TILE || hitFromSource.hitType != HitResult.HitType.TILE) {
            this.setLowpassIntensity(EFXConfig.NOEFFECT_LOWPASS, client.timer.partialTicks);
            return;
        }
        RoomDescription roomDescription = this.calculateRoomDescription(client, entity);
        float averageDistance = roomDescription.averageDistance;
        int numRays = roomDescription.numRays;
        int escapedRays = roomDescription.escapedRays;
        RoomDescription roomDescriptionFromEars = this.calculateRoomDescription(client, (Player)client.thePlayer);
        float averageDistanceFromEars = roomDescriptionFromEars.averageDistance;
        int numRaysFromEars = roomDescriptionFromEars.numRays;
        int escapedRaysFromEars = roomDescriptionFromEars.escapedRays;
        boolean isInRoom = numRays > 0 && (float)escapedRays / (float)numRays < 0.5f;
        boolean bl = isInRoomFromEars = numRaysFromEars > 0 && (float)escapedRaysFromEars / (float)numRaysFromEars < 0.5f;
        if (!isInRoom && !isInRoomFromEars) {
            this.setLowpassIntensity(EFXConfig.NOEFFECT_LOWPASS, client.timer.partialTicks);
            return;
        }
        double thickness = hitFromEars.location.distanceTo(hitFromSource.location);
        Block blockAtEars = client.currentWorld.getBlock(hitFromEars.x, hitFromEars.y, hitFromEars.z);
        Block blockAtSource = client.currentWorld.getBlock(hitFromSource.x, hitFromSource.y, hitFromSource.z);
        assert (blockAtEars != null);
        assert (blockAtSource != null);
        float resistance = 0.0f;
        resistance += blockAtEars.blastResistance + blockAtSource.blastResistance;
        int i = 0;
        while ((double)i < thickness && !(resistance > EFXConfig.TWO_BLOCK_RESISTANCE_REF)) {
            Vec3 dir = hitFromSource.location.add((double)(-hitFromSource.x), (double)(-hitFromSource.y), (double)(-hitFromSource.z)).normalize().scale((double)i);
            Vec3 pos = hitFromEars.location.add(dir.x, dir.y, dir.z);
            Block block = client.currentWorld.getBlock((int)pos.x, (int)pos.y, (int)pos.z);
            if (block != null) {
                resistance += block.blastResistance;
            }
            ++i;
        }
        float finalIntensity = EFX.getFinalIntensity(intensityOptionFloatValue, thickness, resistance /= EFXConfig.TWO_BLOCK_RESISTANCE_REF);
        this.setLowpassIntensity(finalIntensity, client.timer.partialTicks);
    }

    private static float getFinalIntensity(float intensityOptionFloatValue, double thickness, float resistance) {
        float baseIntensityFormula = (float)MathHelper.lerp((double)EFXConfig.NOEFFECT_LOWPASS, (double)0.0, (double)MathHelper.clamp((double)(thickness / (double)EFXConfig.REFERENCE_DISTANCE), (double)0.0, (double)1.0));
        baseIntensityFormula = MathHelper.lerp((float)EFXConfig.NOEFFECT_LOWPASS, (float)baseIntensityFormula, (float)resistance);
        baseIntensityFormula = MathHelper.clamp((float)baseIntensityFormula, (float)0.0f, (float)1.0f);
        float intensityFromPlayer = MathHelper.clamp((float)intensityOptionFloatValue, (float)0.0f, (float)1.0f);
        return MathHelper.lerp((float)baseIntensityFormula, (float)1.0f, (float)(1.0f - intensityFromPlayer));
    }

    public RoomDescription calculateRoomDescription(Minecraft client, Player entity) {
        Vec3 pos = entity.getPosition(client.timer.partialTicks, true);
        float maxDistance = 5.0f;
        float totalDistance = 0.0f;
        int escapedRays = 0;
        int numRays = 0;
        int escapedMouthRays = 0;
        for (Vec3 dir : directions) {
            Vec3 normalizedDir = Vec3.getTempVec3((double)dir.x, (double)dir.y, (double)dir.z).normalize();
            HitResult hit = client.currentWorld.checkBlockCollisionBetweenPoints(pos, Vec3.getTempVec3((double)pos.x, (double)pos.y, (double)pos.z).add(normalizedDir.x * (double)maxDistance, normalizedDir.y * (double)maxDistance, normalizedDir.z * (double)maxDistance), true);
            Block block = null;
            if (hit != null && hit.hitType == HitResult.HitType.TILE) {
                block = client.currentWorld.getBlock(hit.x, hit.y, hit.z);
            }
            if (block != null && (block.getMaterial().isSolid() || block.getMaterial().isLiquid())) {
                float distance = (float)hit.location.distanceTo(pos);
                totalDistance += distance;
                ++numRays;
                continue;
            }
            ++escapedRays;
            if (!(normalizedDir.dotProduct(entity.getLookAngle()) >= 0.5)) continue;
            ++escapedMouthRays;
        }
        if (numRays == 0) {
            totalDistance = maxDistance * (float)directions.size();
            numRays = directions.size();
        }
        float averageDistance = totalDistance / (float)numRays;
        return new RoomDescription(averageDistance, numRays, escapedRays);
    }

    public void setReverbEnabled(boolean enable) {
        if (this.reverbSlot == null || this.reverbEffect == null) {
            return;
        }
        if (enable && !this.reverbEnabled) {
            AL11.alSource3i((int)this.source, (int)131078, (int)this.reverbEffect, (int)0, (int)0);
        } else if (!enable && this.reverbEnabled) {
            AL11.alSource3i((int)this.source, (int)131078, (int)0, (int)0, (int)0);
        }
    }

    @Override
    public void close() {
        if (this.lowpassFilter != null) {
            EXTEfx.alDeleteFilters((int)this.lowpassFilter);
            this.lowpassFilter = null;
        }
        if (this.reverbEffect != null) {
            EXTEfx.alDeleteEffects((int)this.reverbEffect);
            this.reverbEffect = null;
        }
        if (this.reverbSlot != null) {
            EXTEfx.alDeleteAuxiliaryEffectSlots((int)this.reverbSlot);
            this.reverbSlot = null;
        }
    }

    public static class RoomDescription {
        final float averageDistance;
        final int numRays;
        final int escapedRays;

        RoomDescription(float averageDistance, int numRays, int escapedRays) {
            this.averageDistance = averageDistance;
            this.numRays = numRays;
            this.escapedRays = escapedRays;
        }
    }
}

