/*
 * Decompiled with CFR 0.152.
 */
package fiveavian.proxvc.vc.server;

import fiveavian.proxvc.ProxVCServer;
import fiveavian.proxvc.util.BufferAES;
import fiveavian.proxvc.util.DatagramPacketWrapper;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.util.helper.AES;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.PlayerServer;

public class VCRelayServer
implements Runnable {
    private final MinecraftServer server;
    private final DatagramSocket socket;
    private final DatagramPacketWrapper packet;
    private final HashMap<SocketAddress, PlayerServer> connections = new HashMap();
    private final ByteBuffer samples = ByteBuffer.allocate(1040);

    public VCRelayServer(ProxVCServer vcServer) {
        this.server = vcServer.server;
        this.socket = vcServer.socket;
        this.packet = new DatagramPacketWrapper(this.socket, 1044);
    }

    @Override
    public void run() {
        while (!this.socket.isClosed()) {
            try {
                this.handleNextPacket();
            }
            catch (SocketException socketException) {
            }
            catch (Exception ex) {
                System.out.println("Caught an exception during the relay server loop.");
                ex.printStackTrace();
            }
        }
        System.out.println("Exited relay server loop.");
    }

    private void handleNextPacket() throws Exception {
        this.packet.receive();
        SocketAddress address = this.packet.packet.getSocketAddress();
        int entityId = this.packet.buffer.getInt();
        PlayerServer player = this.getPlayerById(entityId);
        if (player == null) {
            return;
        }
        this.samples.rewind();
        this.samples.limit(1040);
        BufferAES.decrypt((Key)AES.keyChain.get(player.username), this.packet.buffer, this.samples);
        this.samples.limit(1024);
        this.connections.put(this.packet.packet.getSocketAddress(), player);
        this.connections.entrySet().removeIf(this::isConnectionOffline);
        for (SocketAddress key : this.connections.keySet()) {
            this.shareSamples(address, player, key, this.connections.get(key));
        }
    }

    private PlayerServer getPlayerById(int id) {
        for (PlayerServer player : this.server.playerList.playerEntities) {
            if (player.id != id) continue;
            return player;
        }
        return null;
    }

    private boolean isConnectionOffline(Map.Entry<SocketAddress, PlayerServer> entry) {
        return this.getPlayerById(entry.getValue().id) == null;
    }

    private void shareSamples(SocketAddress sourceAddress, PlayerServer sourcePlayer, SocketAddress address, PlayerServer player) throws Exception {
        if (sourceAddress.equals(address) || sourcePlayer.id == player.id) {
            return;
        }
        this.samples.rewind();
        this.packet.buffer.position(4);
        BufferAES.encrypt((Key)AES.keyChain.get(player.username), this.samples, this.packet.buffer);
        this.packet.send(address);
    }
}

