/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.mixin;

import java.nio.FloatBuffer;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.phys.AABB;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sunsetsatellite.catalyst.core.util.model.IColorOverride;
import sunsetsatellite.catalyst.core.util.model.IFullbright;
import sunsetsatellite.catalyst.core.util.vector.Vec4f;

@Mixin(value={BlockModelStandard.class}, remap=false)
public abstract class BlockModelStandardMixin
extends BlockModel<BlockLogic>
implements IColorOverride,
IFullbright {
    private boolean overrideColor = false;
    @Unique
    private Vec4f colorOverride = new Vec4f(1.0);
    @Unique
    private boolean fullbright = false;

    private BlockModelStandardMixin(Block<BlockLogic> block) {
        super(block);
    }

    @Inject(method={"renderBlockOnInventory(Lnet/minecraft/client/render/tessellator/Tessellator;IFFLjava/lang/Integer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/block/model/BlockModelStandard;getBlockBoundsForItemRender()Lnet/minecraft/core/util/phys/AABB;")})
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, Integer lightmapCoordinate, CallbackInfo ci) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloatv((int)2816, (FloatBuffer)buffer);
        if (this.overrideColor) {
            GL11.glColor4d((double)(this.colorOverride.x * (double)buffer.get(0)), (double)(this.colorOverride.y * (double)buffer.get(1)), (double)(this.colorOverride.z * (double)buffer.get(2)), (double)(this.colorOverride.w * (double)buffer.get(3)));
        }
    }

    @Inject(method={"renderBlockWithBounds(Lnet/minecraft/client/render/tessellator/Tessellator;Lnet/minecraft/core/util/phys/AABB;IFFLjava/lang/Integer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/tessellator/Tessellator;startDrawingQuads()V", shift=At.Shift.AFTER)})
    public void disableLightmap(Tessellator tessellator, AABB bounds, int metadata, float brightness, float alpha, Integer lightmapCoordinate, CallbackInfo ci) {
        if (LightmapHelper.isLightmapEnabled() && this.fullbright) {
            tessellator.setLightmapCoord(LightmapHelper.getLightmapCoord((int)15, (int)15));
        }
    }

    @Override
    public void overrideColor(float r, float g, float b, float alpha) {
        this.colorOverride = new Vec4f(r, g, b, alpha);
    }

    @Override
    public void enableColorOverride() {
        this.overrideColor = true;
    }

    @Override
    public void disableColorOverride() {
        this.overrideColor = false;
    }

    @Override
    public void enableFullbright() {
        this.fullbright = true;
    }

    @Override
    public void disableFullbright() {
        this.fullbright = false;
    }
}

