/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.mixin;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.world.save.LevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sunsetsatellite.catalyst.core.util.mixin.interfaces.IAbsoluteWorldTime;

@Mixin(value={LevelData.class}, remap=false)
public class LevelDataMixin
implements IAbsoluteWorldTime {
    @Unique
    private long absoluteWorldTime;

    @Override
    public long getAbsoluteWorldTime() {
        return this.absoluteWorldTime;
    }

    @Override
    public void setAbsoluteWorldTime(long value) {
        this.absoluteWorldTime = value;
    }

    @Inject(method={"<init>(Lnet/minecraft/core/world/save/LevelData;)V"}, at={@At(value="TAIL")})
    public void init(LevelData levelData, CallbackInfo ci) {
        this.absoluteWorldTime = ((IAbsoluteWorldTime)levelData).getAbsoluteWorldTime();
    }

    @Inject(method={"readFromCompoundTag(Lcom/mojang/nbt/tags/CompoundTag;)V"}, at={@At(value="HEAD")})
    public void read(CompoundTag tag, CallbackInfo ci) {
        this.absoluteWorldTime = tag.getLong("AbsoluteTime");
    }

    @Inject(method={"updateTagCompound(Lcom/mojang/nbt/tags/CompoundTag;Lcom/mojang/nbt/tags/CompoundTag;)V"}, at={@At(value="HEAD")})
    public void write(CompoundTag levelTag, CompoundTag playerTag, CallbackInfo ci) {
        levelTag.putLong("AbsoluteTime", this.absoluteWorldTime);
    }
}

