/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.UUID;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.World;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.PlayerServer;
import net.minecraft.server.net.PlayerList;
import net.minecraft.server.net.handler.PacketHandlerLogin;
import net.minecraft.server.world.ServerPlayerController;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import sunsetsatellite.catalyst.core.util.mp.PacketBlockNetworkData;
import sunsetsatellite.catalyst.core.util.network.Network;
import sunsetsatellite.catalyst.core.util.network.NetworkManager;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

@Mixin(value={PlayerList.class}, remap=false)
public class PlayerListMixin {
    @Shadow
    @Final
    private MinecraftServer server;

    @Inject(method={"getPlayerForLogin(Lnet/minecraft/server/net/handler/PacketHandlerLogin;Ljava/lang/String;Ljava/util/UUID;)Lnet/minecraft/server/entity/player/PlayerServer;"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/net/handler/PacketHandlerServer;kickPlayer(Ljava/lang/String;)V", shift=At.Shift.BEFORE)}, cancellable=true)
    public void getPlayerForLogin(PacketHandlerLogin handler, String username, UUID uuid, CallbackInfoReturnable<PlayerServer> cir, @Local(name={"player"}) PlayerServer player) {
        if (player.uuid == null && uuid == null) {
            cir.setReturnValue((Object)new PlayerServer(this.server, (World)this.server.getDimensionWorld(0), username, uuid, new ServerPlayerController(this.server.getDimensionWorld(0))));
        }
    }

    @Inject(method={"sendPlayerToOtherDimension(Lnet/minecraft/server/entity/player/PlayerServer;ILnet/minecraft/core/util/helper/DyeColor;Z)V"}, at={@At(value="TAIL")})
    public void sendPlayerToOtherDimension(PlayerServer playerServer, int targetDim, DyeColor portalColor, boolean generatePortal, CallbackInfo ci) {
        if (playerServer.world != null) {
            for (Network network : NetworkManager.getNetsForDimension(playerServer.world.dimension.id)) {
                network.update();
            }
            NetworkHandler.sendToPlayer((Player)playerServer, (NetworkMessage)new PacketBlockNetworkData(playerServer.world));
        }
    }
}

