/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util.section;

import net.minecraft.core.util.helper.Side;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.vector.Vec2f;

public enum BlockSection {
    TOP_LEFT(new Vec2f(0.0, 0.8), new Vec2f(0.2, 0.1)),
    BOTTOM_LEFT(new Vec2f(0.0, 0.0), new Vec2f(0.2, 0.2)),
    CENTER_LEFT(new Vec2f(0.0, 0.4), new Vec2f(0.2, 0.6)),
    TOP_RIGHT(new Vec2f(0.8, 0.8), new Vec2f(1.0, 1.0)),
    BOTTOM_RIGHT(new Vec2f(0.8, 0.0), new Vec2f(1.0, 0.2)),
    CENTER_RIGHT(new Vec2f(0.8, 0.4), new Vec2f(1.0, 0.6)),
    UPPER_CENTER(new Vec2f(0.4, 1.0), new Vec2f(0.6, 0.8)),
    LOWER_CENTER(new Vec2f(0.4, 0.0), new Vec2f(0.6, 0.2)),
    CENTER(new Vec2f(0.4, 0.4), new Vec2f(0.6, 0.6));

    public final Vec2f min;
    public final Vec2f max;

    private BlockSection(Vec2f min, Vec2f max) {
        this.min = min;
        this.max = max;
    }

    public static BlockSection getClosestBlockSection(Vec2f vec) {
        double bestDistance = Double.MAX_VALUE;
        BlockSection bestSection = null;
        for (BlockSection section : BlockSection.values()) {
            double maxDistance;
            double minDistance = vec.distanceTo(section.min);
            double currentMinimumDistance = Math.min(minDistance, maxDistance = vec.distanceTo(section.max));
            if (!(currentMinimumDistance < bestDistance)) continue;
            bestDistance = currentMinimumDistance;
            bestSection = section;
        }
        return bestSection;
    }

    public Direction toDirection(Direction blockSide, Side playerFacing) {
        if (blockSide.getAxis().isVertical()) {
            switch (this.ordinal()) {
                case 0: 
                case 1: 
                case 3: 
                case 4: {
                    return blockSide.getOpposite();
                }
                case 2: {
                    return Direction.X_NEG;
                }
                case 5: {
                    return Direction.X_POS;
                }
                case 6: {
                    return Direction.Z_POS;
                }
                case 7: {
                    return Direction.Z_NEG;
                }
                case 8: {
                    return blockSide;
                }
            }
        } else {
            switch (this.ordinal()) {
                case 0: 
                case 1: 
                case 3: 
                case 4: {
                    return blockSide.getOpposite();
                }
                case 2: {
                    switch (playerFacing) {
                        case NORTH: {
                            return Direction.X_NEG;
                        }
                        case EAST: {
                            return Direction.Z_NEG;
                        }
                        case SOUTH: {
                            return Direction.X_POS;
                        }
                        case WEST: {
                            return Direction.Z_POS;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (playerFacing) {
                        case NORTH: {
                            return Direction.X_POS;
                        }
                        case EAST: {
                            return Direction.Z_POS;
                        }
                        case SOUTH: {
                            return Direction.X_NEG;
                        }
                        case WEST: {
                            return Direction.Z_NEG;
                        }
                    }
                    break;
                }
                case 6: {
                    return Direction.Y_POS;
                }
                case 7: {
                    return Direction.Y_NEG;
                }
                case 8: {
                    return blockSide;
                }
            }
        }
        return null;
    }
}

